/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v1.params;

import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.immutables.builder.Builder;
import org.projectnessie.api.v1.params.AbstractParams;
import org.projectnessie.api.v1.params.RefLogParamsBuilder;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class RefLogParams
extends AbstractParams<RefLogParams> {
    @Nullable
    @jakarta.annotation.Nullable
    @javax.validation.constraints.Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes")
    @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes")
    @Parameter(description="Hash of the reflog (inclusive) to start from (in chronological sense), the 'far' end of the reflog, returned 'late' in the result.")
    @QueryParam(value="startHash")
    @jakarta.ws.rs.QueryParam(value="startHash")
    private @javax.validation.constraints.Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes") @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes") String startHash;
    @Nullable
    @jakarta.annotation.Nullable
    @javax.validation.constraints.Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes")
    @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes")
    @Parameter(description="Hash of the reflog (inclusive) to end at (in chronological sense), the 'near' end of the reflog, returned 'early' in the result.")
    @QueryParam(value="endHash")
    @jakarta.ws.rs.QueryParam(value="endHash")
    private @javax.validation.constraints.Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes") @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes") String endHash;
    @Nullable
    @jakarta.annotation.Nullable
    @Parameter(description="A Common Expression Language (CEL) expression. An intro to CEL can be found at https://github.com/google/cel-spec/blob/master/doc/intro.md.\n\nUsable variables within the expression are:\n\n- 'reflog' with fields 'refLogId' (string), 'refName' (string), 'commitHash' (string), 'parentRefLogId' (string), ',operation' (string), 'operationTime' (long)\n\nHint: when filtering entries, you can determine whether entries are \"missing\" (filtered) by checking whether 'ReflogResponseEntry.parentRefLogId' is different from the hash of the previous reflog in the log response.")
    @QueryParam(value="filter")
    @jakarta.ws.rs.QueryParam(value="filter")
    private String filter;

    public RefLogParams() {
    }

    @Builder.Constructor
    RefLogParams(@Nullable @jakarta.annotation.Nullable String startHash, @Nullable @jakarta.annotation.Nullable String endHash, @Nullable @jakarta.annotation.Nullable Integer maxRecords, @Nullable @jakarta.annotation.Nullable String pageToken, @Nullable @jakarta.annotation.Nullable String filter) {
        super(maxRecords, pageToken);
        this.startHash = startHash;
        this.endHash = endHash;
        this.filter = filter;
    }

    @Nullable
    @jakarta.annotation.Nullable
    public String startHash() {
        return this.startHash;
    }

    @Nullable
    @jakarta.annotation.Nullable
    public String endHash() {
        return this.endHash;
    }

    @Nullable
    @jakarta.annotation.Nullable
    public String filter() {
        return this.filter;
    }

    public static RefLogParamsBuilder builder() {
        return new RefLogParamsBuilder();
    }

    public static RefLogParams empty() {
        return RefLogParams.builder().build();
    }

    @Override
    public RefLogParams forNextPage(String pageToken) {
        return new RefLogParams(this.startHash, this.endHash, this.maxRecords(), pageToken, this.filter);
    }

    public String toString() {
        return new StringJoiner(", ", RefLogParams.class.getSimpleName() + "[", "]").add("startHash='" + this.startHash + "'").add("endHash='" + this.endHash + "'").add("filter='" + this.filter + "'").add("maxRecords=" + this.maxRecords()).add("pageToken='" + this.pageToken() + "'").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RefLogParams)) {
            return false;
        }
        RefLogParams that = (RefLogParams)o;
        return Objects.equals(this.startHash, that.startHash) && Objects.equals(this.endHash, that.endHash) && Objects.equals(this.filter, that.filter) && Objects.equals(this.maxRecords(), that.maxRecords()) && Objects.equals(this.pageToken(), that.pageToken());
    }

    public int hashCode() {
        return Objects.hash(this.startHash, this.endHash, this.filter, this.maxRecords(), this.pageToken());
    }
}

