/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v2;

import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.projectnessie.api.v2.params.CommitLogParams;
import org.projectnessie.api.v2.params.DiffParams;
import org.projectnessie.api.v2.params.EntriesParams;
import org.projectnessie.api.v2.params.GetReferenceParams;
import org.projectnessie.api.v2.params.Merge;
import org.projectnessie.api.v2.params.ReferencesParams;
import org.projectnessie.api.v2.params.Transplant;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.CommitResponse;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ContentResponse;
import org.projectnessie.model.DiffResponse;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.GetMultipleContentsRequest;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.MergeResponse;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferencesResponse;
import org.projectnessie.model.SingleReferenceResponse;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface TreeApi {
    public ReferencesResponse getAllReferences(ReferencesParams var1);

    public SingleReferenceResponse createReference(@Valid @NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Valid @NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String var1, @Valid @NotNull Reference.ReferenceType var2, @Valid @Nullable Reference var3) throws NessieNotFoundException, NessieConflictException;

    public SingleReferenceResponse getReferenceByName(@Valid @NotNull GetReferenceParams var1) throws NessieNotFoundException;

    public EntriesResponse getEntries(@Valid @NotNull @Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a commit hash, which must consist of the hex representation of 4-32 bytes, optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit") @Valid @NotNull @Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a commit hash, which must consist of the hex representation of 4-32 bytes, optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit") String var1, @Valid @NotNull EntriesParams var2) throws NessieNotFoundException;

    public LogResponse getCommitLog(@Valid @NotNull @Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a commit hash, which must consist of the hex representation of 4-32 bytes, optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit") @Valid @NotNull @Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a commit hash, which must consist of the hex representation of 4-32 bytes, optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit") String var1, @Valid @NotNull CommitLogParams var2) throws NessieNotFoundException;

    public DiffResponse getDiff(@Valid @NotNull DiffParams var1) throws NessieNotFoundException;

    public SingleReferenceResponse assignReference(@Valid Reference.ReferenceType var1, @Valid @NotNull @Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a commit hash, which must consist of the hex representation of 4-32 bytes, optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit") @Valid @NotNull @Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a commit hash, which must consist of the hex representation of 4-32 bytes, optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit") String var2, @Valid @NotNull Reference var3) throws NessieNotFoundException, NessieConflictException;

    public SingleReferenceResponse deleteReference(@Valid Reference.ReferenceType var1, @Valid @NotNull @Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a commit hash, which must consist of the hex representation of 4-32 bytes, optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit") @Valid @NotNull @Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a commit hash, which must consist of the hex representation of 4-32 bytes, optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit") String var2) throws NessieConflictException, NessieNotFoundException;

    public MergeResponse transplantCommitsIntoBranch(@Valid @NotNull @Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a commit hash, which must consist of the hex representation of 4-32 bytes, optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit") @Valid @NotNull @Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a commit hash, which must consist of the hex representation of 4-32 bytes, optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit") String var1, @Valid Transplant var2) throws NessieNotFoundException, NessieConflictException;

    public MergeResponse mergeRefIntoBranch(@Valid @NotNull @Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a commit hash, which must consist of the hex representation of 4-32 bytes, optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit") @Valid @NotNull @Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a commit hash, which must consist of the hex representation of 4-32 bytes, optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit") String var1, @Valid @NotNull Merge var2) throws NessieNotFoundException, NessieConflictException;

    public CommitResponse commitMultipleOperations(@Valid @NotNull @Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a commit hash, which must consist of the hex representation of 4-32 bytes, optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit") @Valid @NotNull @Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a commit hash, which must consist of the hex representation of 4-32 bytes, optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit") String var1, @Valid @NotNull Operations var2) throws NessieNotFoundException, NessieConflictException;

    public ContentResponse getContent(@Valid ContentKey var1, @Valid @Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a commit hash, which must consist of the hex representation of 4-32 bytes, optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit") @Valid @Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a commit hash, which must consist of the hex representation of 4-32 bytes, optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit") String var2, boolean var3) throws NessieNotFoundException;

    public GetMultipleContentsResponse getMultipleContents(@Valid @Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a commit hash, which must consist of the hex representation of 4-32 bytes, optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit") @Valid @Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a commit hash, which must consist of the hex representation of 4-32 bytes, optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit") String var1, @Valid @NotNull GetMultipleContentsRequest var2, boolean var3) throws NessieNotFoundException;
}

