/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.error;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import org.projectnessie.error.NessieBackendThrottledException;
import org.projectnessie.error.NessieBadRequestException;
import org.projectnessie.error.NessieContentNotFoundException;
import org.projectnessie.error.NessieError;
import org.projectnessie.error.NessieForbiddenException;
import org.projectnessie.error.NessieNamespaceAlreadyExistsException;
import org.projectnessie.error.NessieNamespaceNotEmptyException;
import org.projectnessie.error.NessieNamespaceNotFoundException;
import org.projectnessie.error.NessieRefLogNotFoundException;
import org.projectnessie.error.NessieReferenceAlreadyExistsException;
import org.projectnessie.error.NessieReferenceConflictException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.error.NessieUnsupportedMediaTypeException;

public enum ErrorCode {
    UNKNOWN(500, null),
    REFERENCE_NOT_FOUND(404, NessieReferenceNotFoundException::new),
    REFERENCE_ALREADY_EXISTS(409, NessieReferenceAlreadyExistsException::new),
    CONTENT_NOT_FOUND(404, NessieContentNotFoundException::new),
    REFERENCE_CONFLICT(409, NessieReferenceConflictException::new),
    REFLOG_NOT_FOUND(404, NessieRefLogNotFoundException::new),
    BAD_REQUEST(400, NessieBadRequestException::new),
    FORBIDDEN(403, NessieForbiddenException::new),
    TOO_MANY_REQUESTS(429, NessieBackendThrottledException::new),
    NAMESPACE_NOT_FOUND(404, NessieNamespaceNotFoundException::new),
    NAMESPACE_ALREADY_EXISTS(409, NessieNamespaceAlreadyExistsException::new),
    NAMESPACE_NOT_EMPTY(409, NessieNamespaceNotEmptyException::new),
    UNSUPPORTED_MEDIA_TYPE(415, NessieUnsupportedMediaTypeException::new);

    private final int httpStatus;
    private final Function<NessieError, ? extends Exception> exceptionBuilder;

    private <T extends Exception> ErrorCode(int status, Function<NessieError, T> exceptionBuilder) {
        this.httpStatus = status;
        this.exceptionBuilder = exceptionBuilder;
    }

    public int httpStatus() {
        return this.httpStatus;
    }

    public static Optional<Exception> asException(NessieError error) {
        return Optional.ofNullable(error.getErrorCode()).flatMap(e -> Optional.ofNullable(e.exceptionBuilder)).map(b -> (Exception)b.apply(error));
    }

    public static ErrorCode parse(String errorCode) {
        try {
            if (errorCode != null) {
                return ErrorCode.valueOf(errorCode.toUpperCase(Locale.ROOT));
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return UNKNOWN;
        }
    }

    public static final class Deserializer
    extends JsonDeserializer<ErrorCode> {
        public ErrorCode deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String name = (String)p.readValueAs(String.class);
            return name != null ? ErrorCode.parse(name) : null;
        }
    }
}

