/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v2.http;

import com.fasterxml.jackson.annotation.JsonView;
import jakarta.validation.constraints.Pattern;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PathParam;
import java.util.List;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.projectnessie.api.v2.TreeApi;
import org.projectnessie.api.v2.params.CommitLogParams;
import org.projectnessie.api.v2.params.DiffParams;
import org.projectnessie.api.v2.params.EntriesParams;
import org.projectnessie.api.v2.params.GetReferenceParams;
import org.projectnessie.api.v2.params.Merge;
import org.projectnessie.api.v2.params.ReferencesParams;
import org.projectnessie.api.v2.params.Transplant;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.CommitResponse;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ContentResponse;
import org.projectnessie.model.DiffResponse;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.GetMultipleContentsRequest;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.MergeResponse;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferencesResponse;
import org.projectnessie.model.SingleReferenceResponse;
import org.projectnessie.model.ser.Views;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@javax.ws.rs.Consumes(value={"application/json"})
@Consumes(value={"application/json"})
@Path(value="v2/trees")
@jakarta.ws.rs.Path(value="v2/trees")
@Tag(name="v2")
public interface HttpTreeApi
extends TreeApi {
    @Override
    @javax.ws.rs.GET
    @GET
    @Produces(value={"application/json"})
    @jakarta.ws.rs.Produces(value={"application/json"})
    @Operation(summary="Get information about all branches and tags", operationId="getAllReferencesV2")
    @APIResponses(value={@APIResponse(responseCode="200", description="Returned references.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="referencesResponse"), @ExampleObject(ref="referencesResponseWithMetadata")}, schema=@Schema(implementation=ReferencesResponse.class))}), @APIResponse(responseCode="401", description="Invalid credentials provided")})
    @JsonView(value={Views.V2.class})
    public ReferencesResponse getAllReferences(@javax.ws.rs.BeanParam @BeanParam ReferencesParams var1);

    @Override
    @POST
    @jakarta.ws.rs.POST
    @Produces(value={"application/json"})
    @jakarta.ws.rs.Produces(value={"application/json"})
    @Operation(summary="Create a new branch or tag", description="The name and type query parameters define the kind of reference to be created. The payload object defines the new reference's origin in the commit history. \nOnly branches and tags can be created by this method, but the payload object may be any valid reference, including a detached commit.\nIf the payload reference object does not define a commit hash, the HEAD of that reference will be used.", operationId="createReferenceV2")
    @APIResponses(value={@APIResponse(responseCode="200", description="Created successfully.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="singleReferenceResponse")}, schema=@Schema(implementation=SingleReferenceResponse.class))}), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to create reference"), @APIResponse(responseCode="409", description="Another reference with the same name already exists")})
    @JsonView(value={Views.V2.class})
    public SingleReferenceResponse createReference(@Parameter(required=true, description="A reference name.\n\nReference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'\n") @QueryParam(value="name") @jakarta.ws.rs.QueryParam(value="name") String var1, @Parameter(required=true, description="Type of the reference to be created", examples={@ExampleObject(ref="referenceType")}) @QueryParam(value="type") @jakarta.ws.rs.QueryParam(value="type") String var2, @RequestBody(required=true, description="Source reference data from which the new reference is to be created.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="refObjNew")})}) Reference var3) throws NessieNotFoundException, NessieConflictException;

    @Override
    @javax.ws.rs.GET
    @GET
    @Produces(value={"application/json"})
    @jakarta.ws.rs.Produces(value={"application/json"})
    @Path(value="{ref:([^/]+|[^@]+(@|%40)[^@/]*)}")
    @jakarta.ws.rs.Path(value="{ref:([^/]+|[^@]+(@|%40)[^@/]*)}")
    @Operation(summary="Fetch details of a reference", operationId="getReferenceByNameV2")
    @APIResponses(value={@APIResponse(responseCode="200", description="Found and returned reference.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="singleReferenceResponse"), @ExampleObject(ref="singleReferenceResponseWithMetadata")}, schema=@Schema(implementation=SingleReferenceResponse.class))}), @APIResponse(responseCode="400", description="Invalid input, ref name not valid"), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to view the given reference"), @APIResponse(responseCode="404", description="Ref not found")})
    @JsonView(value={Views.V2.class})
    public SingleReferenceResponse getReferenceByName(@javax.ws.rs.BeanParam @BeanParam GetReferenceParams var1) throws NessieNotFoundException;

    @Override
    @javax.ws.rs.GET
    @GET
    @Produces(value={"application/json"})
    @jakarta.ws.rs.Produces(value={"application/json"})
    @Path(value="{ref:([^/]+|[^@]+(@|%40)[^@/]*)}/entries")
    @jakarta.ws.rs.Path(value="{ref:([^/]+|[^@]+(@|%40)[^@/]*)}/entries")
    @Operation(summary="Fetch all entries for a given reference", description="Retrieves objects for a ref, potentially truncated by the backend.\n\nRetrieves up to 'maxRecords' entries for the given named reference (tag or branch) or the given hash. The backend may respect the given 'max' records hint, but return less or more entries. Backends may also cap the returned entries at a hard-coded limit, the default REST server implementation has such a hard-coded limit.\n\nTo implement paging, check 'hasMore' in the response and, if 'true', pass the value returned as 'token' in the next invocation as the 'pageToken' parameter.\n\nThe content and meaning of the returned 'token' is \"private\" to the implementation,treat is as an opaque value.\n\nIt is wrong to assume that invoking this method with a very high 'maxRecords' value will return all available data in one page.\n\nDifferent pages may have different numbers of log records in them even if they come from another call to this method with the same parameters. Also, pages are not guaranteed to be filled to contain exactly 'maxRecords' even if the total amount of available data allows that. Pages may contain more of less entries at server's discretion.\n\nThe 'filter' parameter allows for advanced filtering capabilities using the Common Expression Language (CEL).\nAn intro to CEL can be found at https://github.com/google/cel-spec/blob/master/doc/intro.md.\n", operationId="getEntriesV2")
    @APIResponses(value={@APIResponse(description="List names and object types in a contents tree", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="entriesResponseV2")}, schema=@Schema(implementation=EntriesResponse.class))}), @APIResponse(responseCode="200", description="Returned successfully."), @APIResponse(responseCode="400", description="Invalid input, ref name not valid"), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to view the given reference or fetch entries for it"), @APIResponse(responseCode="404", description="Ref not found")})
    @JsonView(value={Views.V2.class})
    public EntriesResponse getEntries(@Parameter(schema=@Schema(pattern="([^/]+|[^@]+(@|%40)[^@/]*)"), description="A reference to a particular version of the contents tree (a point in history).\n\nReference representations consist of:\n- The reference name. '-' means the default branch name.\n- A commit hash prefixed with '@'.\n- A relative commit specification. '~N' means the N-th predecessor commit, '*T' means the commit for which the timestamp T (milliseconds since epoch or ISO-8601 instant) is valid, '^N' means the N-th parentin a commit (N=2 is the merge parent).\n\nIf neither the reference name or the default branch name placeholder '-' is specified, the reference type 'DETACHED' will be assumed.\nIf no commit hash is specified, the HEAD of the specified named reference will be used.\nAn empty reference parameter is not valid.\n\nThis reference can be specified in these forms:\n- \\- (literal minus character) - identifies the HEAD of the default branch.\n- name - Identifies the HEAD commit of a branch or tag.\n- name@hash - Identifies the 'hash' commit on a branch or tag.\n- @hash - Identifies the 'hash' commit in an unspecified branch or tag.\n- -~3 - The 3rd predecessor commit from the HEAD of the default branch.\n- name~3 - The 3rd predecessor commit from the HEAD of a branch or tag.\n- @hash~3 - The 3rd predecessor commit of the 'hash' commit.\n- name@hash^2 - The merge parent of the 'hash' commit of a branch or tag.\n- @hash^2 - The merge parent of the 'hash' commit.\n- -*2021-04-07T14:42:25.534748Z - The predecessor commit closest to the HEAD of the default branch for the given ISO-8601 timestamp.\n- name*2021-04-07T14:42:25.534748Z - The predecessor commit closest to the HEAD of a branch or tag valid for the given ISO-8601 timestamp.\n- name*1685185847230 - The predecessor commit closest to the HEAD of a branch or tag valid for the given timestamp in milliseconds since epoch.\n\nIf both 'name' and 'hash' are given, 'hash' must be reachable from the current HEAD of the branch or tag. If 'name' is omitted, the reference will be of type 'DETACHED' (referencing a specific commit hash without claiming its reachability from any live HEAD). Using references of the last form may have authorization implications when compared to an equivalent reference of the former forms.\n\nAn empty reference parameter is invalid.\n\nThe 'name@hash' form always refers to the exact commit on a specific named reference. This is the most complete form of a reference. Other forms omit some of the details and require those gaps to be filled by the server at runtime. Although these forms may be convenient to a human-being, they may resolve differently at different times depending on the state of the system. Using the full 'name@hash' form is recommended to avoid ambiguity.\n", examples={@ExampleObject(ref="ref"), @ExampleObject(ref="refWithHash"), @ExampleObject(ref="refWithTimestampMillisSinceEpoch", description="The commit 'valid for' the timestamp 1685185847230 in ms since epoch on main"), @ExampleObject(ref="refWithTimestampInstant", description="The commit 'valid for' the given ISO-8601 instant on main"), @ExampleObject(ref="refWithNthPredecessor", description="The 10th commit from HEAD of main"), @ExampleObject(ref="refWithMergeParent", description="References the merge-parent of commit 2e1cfa82b035c26cbbbdae632cea070514eb8b773f616aaeaf668e2f0be8f10d on main"), @ExampleObject(ref="refDefault"), @ExampleObject(ref="refDetached")}) @javax.ws.rs.PathParam(value="ref") @PathParam(value="ref") String var1, @javax.ws.rs.BeanParam @BeanParam EntriesParams var2) throws NessieNotFoundException;

    @Override
    @javax.ws.rs.GET
    @GET
    @Produces(value={"application/json"})
    @jakarta.ws.rs.Produces(value={"application/json"})
    @Path(value="{ref:([^/]+|[^@]+(@|%40)[^@/]*)}/history")
    @jakarta.ws.rs.Path(value="{ref:([^/]+|[^@]+(@|%40)[^@/]*)}/history")
    @Operation(summary="Get commit log for a particular reference", description="Retrieve the commit log for a reference, potentially truncated by the backend.\n\nThe backend may respect the given 'max-entries' records hint, or may return more or less entries. Backends may also cap the returned entries at a hard-coded limit\n\nTo implement paging, check 'hasMore' in the response and, if 'true', pass the value returned as 'token' in the next invocation as the 'pageToken' parameter.\n\nThe content and meaning of the returned 'token' is \"private\" to the implementation,treat is as an opaque value.\n\nIt is wrong to assume that invoking this method with a very high 'maxRecords' value will return all available data in one page.\n\nDifferent pages may have different numbers of log records in them even if they come from another call to this method with the same parameters. Also, pages are not guaranteed to be filled to contain exactly 'maxRecords' even if the total amount of available data allows that. Pages may contain more of less entries at server's discretion.\n\nThe 'filter' parameter allows for advanced filtering capabilities using the Common Expression Language (CEL).\nAn intro to CEL can be found at https://github.com/google/cel-spec/blob/master/doc/intro.md.\n\nThe fetching of the log starts from the HEAD of the given ref (or a more specific commit, if provided as part of the 'ref' path element) and proceeds until the 'root' commit or the 'limit-hash' commit are encountered.", operationId="getCommitLogV2")
    @APIResponses(value={@APIResponse(responseCode="200", description="Returned commits.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="logResponseAdditionalInfo"), @ExampleObject(ref="logResponseSimple")}, schema=@Schema(implementation=LogResponse.class))}), @APIResponse(responseCode="400", description="Invalid input, ref name not valid"), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to view the given reference or get commit log for it"), @APIResponse(responseCode="404", description="Ref doesn't exists")})
    @JsonView(value={Views.V2.class})
    public LogResponse getCommitLog(@Parameter(schema=@Schema(pattern="([^/]+|[^@]+(@|%40)[^@/]*)"), description="A reference to a particular version of the contents tree (a point in history).\n\nReference representations consist of:\n- The reference name. '-' means the default branch name.\n- A commit hash prefixed with '@'.\n- A relative commit specification. '~N' means the N-th predecessor commit, '*T' means the commit for which the timestamp T (milliseconds since epoch or ISO-8601 instant) is valid, '^N' means the N-th parentin a commit (N=2 is the merge parent).\n\nIf neither the reference name or the default branch name placeholder '-' is specified, the reference type 'DETACHED' will be assumed.\nIf no commit hash is specified, the HEAD of the specified named reference will be used.\nAn empty reference parameter is not valid.\n\nThis reference can be specified in these forms:\n- \\- (literal minus character) - identifies the HEAD of the default branch.\n- name - Identifies the HEAD commit of a branch or tag.\n- name@hash - Identifies the 'hash' commit on a branch or tag.\n- @hash - Identifies the 'hash' commit in an unspecified branch or tag.\n- -~3 - The 3rd predecessor commit from the HEAD of the default branch.\n- name~3 - The 3rd predecessor commit from the HEAD of a branch or tag.\n- @hash~3 - The 3rd predecessor commit of the 'hash' commit.\n- name@hash^2 - The merge parent of the 'hash' commit of a branch or tag.\n- @hash^2 - The merge parent of the 'hash' commit.\n- -*2021-04-07T14:42:25.534748Z - The predecessor commit closest to the HEAD of the default branch for the given ISO-8601 timestamp.\n- name*2021-04-07T14:42:25.534748Z - The predecessor commit closest to the HEAD of a branch or tag valid for the given ISO-8601 timestamp.\n- name*1685185847230 - The predecessor commit closest to the HEAD of a branch or tag valid for the given timestamp in milliseconds since epoch.\n\nIf both 'name' and 'hash' are given, 'hash' must be reachable from the current HEAD of the branch or tag. If 'name' is omitted, the reference will be of type 'DETACHED' (referencing a specific commit hash without claiming its reachability from any live HEAD). Using references of the last form may have authorization implications when compared to an equivalent reference of the former forms.\n\nAn empty reference parameter is invalid.\n\nThe 'name@hash' form always refers to the exact commit on a specific named reference. This is the most complete form of a reference. Other forms omit some of the details and require those gaps to be filled by the server at runtime. Although these forms may be convenient to a human-being, they may resolve differently at different times depending on the state of the system. Using the full 'name@hash' form is recommended to avoid ambiguity.\n", examples={@ExampleObject(ref="ref"), @ExampleObject(ref="refWithHash"), @ExampleObject(ref="refWithTimestampMillisSinceEpoch", description="The commit 'valid for' the timestamp 1685185847230 in ms since epoch on main"), @ExampleObject(ref="refWithTimestampInstant", description="The commit 'valid for' the given ISO-8601 instant on main"), @ExampleObject(ref="refWithNthPredecessor", description="The 10th commit from HEAD of main"), @ExampleObject(ref="refWithMergeParent", description="References the merge-parent of commit 2e1cfa82b035c26cbbbdae632cea070514eb8b773f616aaeaf668e2f0be8f10d on main"), @ExampleObject(ref="refDefault"), @ExampleObject(ref="refDetached")}) @javax.ws.rs.PathParam(value="ref") @PathParam(value="ref") String var1, @javax.ws.rs.BeanParam @BeanParam CommitLogParams var2) throws NessieNotFoundException;

    @Override
    @javax.ws.rs.GET
    @GET
    @Produces(value={"application/json"})
    @jakarta.ws.rs.Produces(value={"application/json"})
    @Path(value="{from-ref:([^/]+|[^@]+(@|%40)[^@/]*)}/diff/{to-ref:([^/]+|[^@]+(@|%40)[^@/]*)}")
    @jakarta.ws.rs.Path(value="{from-ref:([^/]+|[^@]+(@|%40)[^@/]*)}/diff/{to-ref:([^/]+|[^@]+(@|%40)[^@/]*)}")
    @Operation(summary="Get contents that differ in the trees specified by the two given references", description="The URL pattern is basically 'from' and 'to' reference specs separated by '/diff/'\n\nExamples: \n- main/diff/myBranch\n- main@1234567890123456/diff/myBranch\n- main@1234567890123456/diff/myBranch@23445678\n- main/diff/myBranch@23445678\n- main/diff/myBranch@23445678\n- my/branch@/diff/main\n- myBranch/diff/-\n", operationId="getDiffV2")
    @APIResponses(value={@APIResponse(responseCode="200", description="Returned diff for the given references.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="diffResponseWithRef")}, schema=@Schema(implementation=DiffResponse.class))}), @APIResponse(responseCode="400", description="Invalid input, fromRef/toRef name not valid"), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to view the given fromRef/toRef"), @APIResponse(responseCode="404", description="fromRef/toRef not found")})
    @JsonView(value={Views.V2.class})
    public DiffResponse getDiff(@javax.ws.rs.BeanParam @BeanParam DiffParams var1) throws NessieNotFoundException;

    @Override
    @PUT
    @jakarta.ws.rs.PUT
    @Produces(value={"application/json"})
    @jakarta.ws.rs.Produces(value={"application/json"})
    @Path(value="{ref:([^/]+|[^@]+(@|%40)[^@/]*)}")
    @jakarta.ws.rs.Path(value="{ref:([^/]+|[^@]+(@|%40)[^@/]*)}")
    @Operation(summary="Set a named reference to a specific hash via another reference.", description="The 'ref' parameter identifies the branch or tag to be reassigned.\nThe 'ref' parameter may contain a hash qualifier. That hash as well as the optional 'type' parameter may be used to ensure the operation is performed on the same object that the user expects.\n\nOnly branches and tags may be reassigned.\nThe payload object identifies any reference visible to the current user whose 'hash' will be used to define the new HEAD of the reference being reassigned. Detached hashes may be used in the payload.", operationId="assignReferenceV2")
    @APIResponses(value={@APIResponse(responseCode="200", description="Assigned successfully.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="singleReferenceResponse")}, schema=@Schema(implementation=SingleReferenceResponse.class))}), @APIResponse(responseCode="400", description="Invalid input, ref specification not valid"), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to view or assign reference"), @APIResponse(responseCode="404", description="One or more references don't exist"), @APIResponse(responseCode="409", description="Update conflict or expected hash / type mismatch")})
    @JsonView(value={Views.V2.class})
    public SingleReferenceResponse assignReference(@Parameter(description="Optional expected type of the reference being reassigned", examples={@ExampleObject(ref="referenceType")}) @QueryParam(value="type") @jakarta.ws.rs.QueryParam(value="type") String var1, @Parameter(schema=@Schema(pattern="([^/]+|[^@]+(@|%40)[^@/]*)"), description="Specifies a named branch or tag reference with its expected HEAD 'hash' value.\n\nFor example:\n- name@hash - Identifies the 'hash' commit on a branch or tag.\n\nThe specified 'hash' must be the value of the current HEAD of the branch or tag known by the client. It will be used to validate that at execution time the reference points to the same hash that the caller expected when the operation arguments were constructed.\n", examples={@ExampleObject(ref="refWithHash")}) @javax.ws.rs.PathParam(value="ref") @PathParam(value="ref") String var2, @RequestBody(required=true, description="Reference to which the 'ref' (from the path parameter) shall be assigned. This must be either a 'Detached' commit, 'Branch' or 'Tag' via which the hash is visible to the caller.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="refObj"), @ExampleObject(ref="tagObj")})}) Reference var3) throws NessieNotFoundException, NessieConflictException;

    @Override
    @javax.ws.rs.DELETE
    @DELETE
    @Produces(value={"application/json"})
    @jakarta.ws.rs.Produces(value={"application/json"})
    @Path(value="{ref:([^/]+|[^@]+(@|%40)[^@/]*)}")
    @jakarta.ws.rs.Path(value="{ref:([^/]+|[^@]+(@|%40)[^@/]*)}")
    @Operation(summary="Delete a reference", description="The 'ref' parameter identifies the branch or tag to be deleted.\nThe 'ref' parameter may contain a hash qualifier. That hash as well as the optional 'type' parameter may be used to ensure the operation is performed on the same object that the user expects.\n\nOnly branches and tags can be deleted. However, deleting the default branch may be restricted.", operationId="deleteReferenceV2")
    @APIResponses(value={@APIResponse(responseCode="200", description="Deleted successfully.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="singleReferenceResponse")}, schema=@Schema(implementation=SingleReferenceResponse.class))}), @APIResponse(responseCode="400", description="Invalid input, ref/hash name not valid"), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to view or delete reference"), @APIResponse(responseCode="404", description="Ref doesn't exists"), @APIResponse(responseCode="409", description="update conflict")})
    @JsonView(value={Views.V2.class})
    public SingleReferenceResponse deleteReference(@Parameter(description="Optional expected type of the reference being deleted", examples={@ExampleObject(ref="referenceType")}) @QueryParam(value="type") @jakarta.ws.rs.QueryParam(value="type") String var1, @Parameter(schema=@Schema(pattern="([^/]+|[^@]+(@|%40)[^@/]*)"), description="Specifies a named branch or tag reference with its expected HEAD 'hash' value.\n\nFor example:\n- name@hash - Identifies the 'hash' commit on a branch or tag.\n\nThe specified 'hash' must be the value of the current HEAD of the branch or tag known by the client. It will be used to validate that at execution time the reference points to the same hash that the caller expected when the operation arguments were constructed.\n", examples={@ExampleObject(ref="refWithHash")}) @javax.ws.rs.PathParam(value="ref") @PathParam(value="ref") String var2) throws NessieConflictException, NessieNotFoundException;

    @Override
    @javax.ws.rs.GET
    @GET
    @Produces(value={"application/json"})
    @jakarta.ws.rs.Produces(value={"application/json"})
    @Path(value="{ref:([^/]+|[^@]+(@|%40)[^@/]*)}/contents/{key}")
    @jakarta.ws.rs.Path(value="{ref:([^/]+|[^@]+(@|%40)[^@/]*)}/contents/{key}")
    @Operation(summary="Get the content object associated with a key.", description="This operation returns the content value for a content key at a particular point in history as defined by the 'ref' parameter.", operationId="getContentV2")
    @APIResponses(value={@APIResponse(responseCode="200", description="Information for a table, view or another content object for the given key", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="contentResponseIceberg")}, schema=@Schema(implementation=ContentResponse.class))}), @APIResponse(responseCode="400", description="Invalid input, ref name not valid"), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to view the given reference or read object content for a key"), @APIResponse(responseCode="404", description="Table not found on 'ref' or non-existent reference")})
    @JsonView(value={Views.V2.class})
    public ContentResponse getContent(@Parameter(description="The key to a content object.\n\nKey components (namespaces) are separated by the dot ('.') character. Dot ('.') characters that are not Nessie namespace separators must be encoded as the 'group separator' ASCII character (0x1D).\n") @javax.ws.rs.PathParam(value="key") @PathParam(value="key") ContentKey var1, @Parameter(schema=@Schema(pattern="([^/]+|[^@]+(@|%40)[^@/]*)"), description="A reference to a particular version of the contents tree (a point in history).\n\nReference representations consist of:\n- The reference name. '-' means the default branch name.\n- A commit hash prefixed with '@'.\n- A relative commit specification. '~N' means the N-th predecessor commit, '*T' means the commit for which the timestamp T (milliseconds since epoch or ISO-8601 instant) is valid, '^N' means the N-th parentin a commit (N=2 is the merge parent).\n\nIf neither the reference name or the default branch name placeholder '-' is specified, the reference type 'DETACHED' will be assumed.\nIf no commit hash is specified, the HEAD of the specified named reference will be used.\nAn empty reference parameter is not valid.\n\nThis reference can be specified in these forms:\n- \\- (literal minus character) - identifies the HEAD of the default branch.\n- name - Identifies the HEAD commit of a branch or tag.\n- name@hash - Identifies the 'hash' commit on a branch or tag.\n- @hash - Identifies the 'hash' commit in an unspecified branch or tag.\n- -~3 - The 3rd predecessor commit from the HEAD of the default branch.\n- name~3 - The 3rd predecessor commit from the HEAD of a branch or tag.\n- @hash~3 - The 3rd predecessor commit of the 'hash' commit.\n- name@hash^2 - The merge parent of the 'hash' commit of a branch or tag.\n- @hash^2 - The merge parent of the 'hash' commit.\n- -*2021-04-07T14:42:25.534748Z - The predecessor commit closest to the HEAD of the default branch for the given ISO-8601 timestamp.\n- name*2021-04-07T14:42:25.534748Z - The predecessor commit closest to the HEAD of a branch or tag valid for the given ISO-8601 timestamp.\n- name*1685185847230 - The predecessor commit closest to the HEAD of a branch or tag valid for the given timestamp in milliseconds since epoch.\n\nIf both 'name' and 'hash' are given, 'hash' must be reachable from the current HEAD of the branch or tag. If 'name' is omitted, the reference will be of type 'DETACHED' (referencing a specific commit hash without claiming its reachability from any live HEAD). Using references of the last form may have authorization implications when compared to an equivalent reference of the former forms.\n\nAn empty reference parameter is invalid.\n\nThe 'name@hash' form always refers to the exact commit on a specific named reference. This is the most complete form of a reference. Other forms omit some of the details and require those gaps to be filled by the server at runtime. Although these forms may be convenient to a human-being, they may resolve differently at different times depending on the state of the system. Using the full 'name@hash' form is recommended to avoid ambiguity.\n", examples={@ExampleObject(ref="ref"), @ExampleObject(ref="refWithHash"), @ExampleObject(ref="refWithTimestampMillisSinceEpoch", description="The commit 'valid for' the timestamp 1685185847230 in ms since epoch on main"), @ExampleObject(ref="refWithTimestampInstant", description="The commit 'valid for' the given ISO-8601 instant on main"), @ExampleObject(ref="refWithNthPredecessor", description="The 10th commit from HEAD of main"), @ExampleObject(ref="refWithMergeParent", description="References the merge-parent of commit 2e1cfa82b035c26cbbbdae632cea070514eb8b773f616aaeaf668e2f0be8f10d on main"), @ExampleObject(ref="refDefault"), @ExampleObject(ref="refDetached")}) @javax.ws.rs.PathParam(value="ref") @PathParam(value="ref") String var2, @Parameter(description="Whether to return the documentation, if it exists. Default is to not return the documentation.") @QueryParam(value="with-doc") @jakarta.ws.rs.QueryParam(value="with-doc") boolean var3) throws NessieNotFoundException;

    @javax.ws.rs.GET
    @GET
    @Produces(value={"application/json"})
    @jakarta.ws.rs.Produces(value={"application/json"})
    @Path(value="{ref:([^/]+|[^@]+(@|%40)[^@/]*)}/contents")
    @jakarta.ws.rs.Path(value="{ref:([^/]+|[^@]+(@|%40)[^@/]*)}/contents")
    @Operation(summary="Get multiple content objects.", description="Similar to 'GET /trees/{ref}/content/{key}', but takes multiple 'key' query parameters and returns zero or more content values in the same JSON structure as the 'POST /trees/{ref}/content' endpoint.\n\nThis is a convenience method for fetching a small number of content objects. It is mostly intended for human use. For automated use cases or when the number of keys is large the 'POST /trees/{ref}/content' method is preferred.")
    @APIResponses(value={@APIResponse(responseCode="200", description="Retrieved successfully.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="multipleContentsResponse")}, schema=@Schema(implementation=GetMultipleContentsResponse.class))}), @APIResponse(responseCode="400", description="Invalid input, ref name not valid"), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to view the given reference or read object content for a key"), @APIResponse(responseCode="404", description="Provided ref doesn't exists")})
    @JsonView(value={Views.V2.class})
    public GetMultipleContentsResponse getSeveralContents(@Parameter(schema=@Schema(pattern="([^/]+|[^@]+(@|%40)[^@/]*)"), description="A reference to a particular version of the contents tree (a point in history).\n\nReference representations consist of:\n- The reference name. '-' means the default branch name.\n- A commit hash prefixed with '@'.\n- A relative commit specification. '~N' means the N-th predecessor commit, '*T' means the commit for which the timestamp T (milliseconds since epoch or ISO-8601 instant) is valid, '^N' means the N-th parentin a commit (N=2 is the merge parent).\n\nIf neither the reference name or the default branch name placeholder '-' is specified, the reference type 'DETACHED' will be assumed.\nIf no commit hash is specified, the HEAD of the specified named reference will be used.\nAn empty reference parameter is not valid.\n\nThis reference can be specified in these forms:\n- \\- (literal minus character) - identifies the HEAD of the default branch.\n- name - Identifies the HEAD commit of a branch or tag.\n- name@hash - Identifies the 'hash' commit on a branch or tag.\n- @hash - Identifies the 'hash' commit in an unspecified branch or tag.\n- -~3 - The 3rd predecessor commit from the HEAD of the default branch.\n- name~3 - The 3rd predecessor commit from the HEAD of a branch or tag.\n- @hash~3 - The 3rd predecessor commit of the 'hash' commit.\n- name@hash^2 - The merge parent of the 'hash' commit of a branch or tag.\n- @hash^2 - The merge parent of the 'hash' commit.\n- -*2021-04-07T14:42:25.534748Z - The predecessor commit closest to the HEAD of the default branch for the given ISO-8601 timestamp.\n- name*2021-04-07T14:42:25.534748Z - The predecessor commit closest to the HEAD of a branch or tag valid for the given ISO-8601 timestamp.\n- name*1685185847230 - The predecessor commit closest to the HEAD of a branch or tag valid for the given timestamp in milliseconds since epoch.\n\nIf both 'name' and 'hash' are given, 'hash' must be reachable from the current HEAD of the branch or tag. If 'name' is omitted, the reference will be of type 'DETACHED' (referencing a specific commit hash without claiming its reachability from any live HEAD). Using references of the last form may have authorization implications when compared to an equivalent reference of the former forms.\n\nAn empty reference parameter is invalid.\n\nThe 'name@hash' form always refers to the exact commit on a specific named reference. This is the most complete form of a reference. Other forms omit some of the details and require those gaps to be filled by the server at runtime. Although these forms may be convenient to a human-being, they may resolve differently at different times depending on the state of the system. Using the full 'name@hash' form is recommended to avoid ambiguity.\n", examples={@ExampleObject(ref="ref"), @ExampleObject(ref="refWithHash"), @ExampleObject(ref="refWithTimestampMillisSinceEpoch", description="The commit 'valid for' the timestamp 1685185847230 in ms since epoch on main"), @ExampleObject(ref="refWithTimestampInstant", description="The commit 'valid for' the given ISO-8601 instant on main"), @ExampleObject(ref="refWithNthPredecessor", description="The 10th commit from HEAD of main"), @ExampleObject(ref="refWithMergeParent", description="References the merge-parent of commit 2e1cfa82b035c26cbbbdae632cea070514eb8b773f616aaeaf668e2f0be8f10d on main"), @ExampleObject(ref="refDefault"), @ExampleObject(ref="refDetached")}) @javax.validation.constraints.Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a hash with optional relative part. Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") @Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a hash with optional relative part. Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") @javax.ws.rs.PathParam(value="ref") @PathParam(value="ref") @javax.validation.constraints.Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a hash with optional relative part. Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") @Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a hash with optional relative part. Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") String var1, @Parameter(description="The key to a content object.\n\nKey components (namespaces) are separated by the dot ('.') character. Dot ('.') characters that are not Nessie namespace separators must be encoded as the 'group separator' ASCII character (0x1D).\n") @QueryParam(value="key") @jakarta.ws.rs.QueryParam(value="key") List<String> var2, @Parameter(description="Whether to return the documentation, if it exists. Default is to not return the documentation.") @QueryParam(value="with-doc") @jakarta.ws.rs.QueryParam(value="with-doc") boolean var3) throws NessieNotFoundException;

    @Override
    @POST
    @jakarta.ws.rs.POST
    @Produces(value={"application/json"})
    @jakarta.ws.rs.Produces(value={"application/json"})
    @javax.ws.rs.Consumes(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="{ref:([^/]+|[^@]+(@|%40)[^@/]*)}/contents")
    @jakarta.ws.rs.Path(value="{ref:([^/]+|[^@]+(@|%40)[^@/]*)}/contents")
    @Operation(summary="Get multiple content objects.", description="Similar to 'GET /trees/{ref}/content/{key}', but takes multiple 'ContentKey's (in the JSON payload) and returns zero or more content objects.\n\nNote that if some keys from the request do not have an associated content object at the point in history defined by the 'ref' parameter, the response will be successful, but no data will be returned for the missing keys.", operationId="getMultipleContentsV2")
    @APIResponses(value={@APIResponse(responseCode="200", description="Retrieved successfully.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="multipleContentsResponse")}, schema=@Schema(implementation=GetMultipleContentsResponse.class))}), @APIResponse(responseCode="400", description="Invalid input, ref name not valid"), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to view the given reference or read object content for a key"), @APIResponse(responseCode="404", description="Provided ref doesn't exists")})
    @JsonView(value={Views.V2.class})
    public GetMultipleContentsResponse getMultipleContents(@Parameter(schema=@Schema(pattern="([^/]+|[^@]+(@|%40)[^@/]*)"), description="A reference to a particular version of the contents tree (a point in history).\n\nReference representations consist of:\n- The reference name. '-' means the default branch name.\n- A commit hash prefixed with '@'.\n- A relative commit specification. '~N' means the N-th predecessor commit, '*T' means the commit for which the timestamp T (milliseconds since epoch or ISO-8601 instant) is valid, '^N' means the N-th parentin a commit (N=2 is the merge parent).\n\nIf neither the reference name or the default branch name placeholder '-' is specified, the reference type 'DETACHED' will be assumed.\nIf no commit hash is specified, the HEAD of the specified named reference will be used.\nAn empty reference parameter is not valid.\n\nThis reference can be specified in these forms:\n- \\- (literal minus character) - identifies the HEAD of the default branch.\n- name - Identifies the HEAD commit of a branch or tag.\n- name@hash - Identifies the 'hash' commit on a branch or tag.\n- @hash - Identifies the 'hash' commit in an unspecified branch or tag.\n- -~3 - The 3rd predecessor commit from the HEAD of the default branch.\n- name~3 - The 3rd predecessor commit from the HEAD of a branch or tag.\n- @hash~3 - The 3rd predecessor commit of the 'hash' commit.\n- name@hash^2 - The merge parent of the 'hash' commit of a branch or tag.\n- @hash^2 - The merge parent of the 'hash' commit.\n- -*2021-04-07T14:42:25.534748Z - The predecessor commit closest to the HEAD of the default branch for the given ISO-8601 timestamp.\n- name*2021-04-07T14:42:25.534748Z - The predecessor commit closest to the HEAD of a branch or tag valid for the given ISO-8601 timestamp.\n- name*1685185847230 - The predecessor commit closest to the HEAD of a branch or tag valid for the given timestamp in milliseconds since epoch.\n\nIf both 'name' and 'hash' are given, 'hash' must be reachable from the current HEAD of the branch or tag. If 'name' is omitted, the reference will be of type 'DETACHED' (referencing a specific commit hash without claiming its reachability from any live HEAD). Using references of the last form may have authorization implications when compared to an equivalent reference of the former forms.\n\nAn empty reference parameter is invalid.\n\nThe 'name@hash' form always refers to the exact commit on a specific named reference. This is the most complete form of a reference. Other forms omit some of the details and require those gaps to be filled by the server at runtime. Although these forms may be convenient to a human-being, they may resolve differently at different times depending on the state of the system. Using the full 'name@hash' form is recommended to avoid ambiguity.\n", examples={@ExampleObject(ref="ref"), @ExampleObject(ref="refWithHash"), @ExampleObject(ref="refWithTimestampMillisSinceEpoch", description="The commit 'valid for' the timestamp 1685185847230 in ms since epoch on main"), @ExampleObject(ref="refWithTimestampInstant", description="The commit 'valid for' the given ISO-8601 instant on main"), @ExampleObject(ref="refWithNthPredecessor", description="The 10th commit from HEAD of main"), @ExampleObject(ref="refWithMergeParent", description="References the merge-parent of commit 2e1cfa82b035c26cbbbdae632cea070514eb8b773f616aaeaf668e2f0be8f10d on main"), @ExampleObject(ref="refDefault"), @ExampleObject(ref="refDetached")}) @javax.ws.rs.PathParam(value="ref") @PathParam(value="ref") String var1, @RequestBody(description="Keys to retrieve.", content={@Content(examples={@ExampleObject(ref="multiGetRequest")})}) GetMultipleContentsRequest var2, @Parameter(description="Whether to return the documentation, if it exists. Default is to not return the documentation.") @QueryParam(value="with-doc") @jakarta.ws.rs.QueryParam(value="with-doc") boolean var3) throws NessieNotFoundException;

    @Override
    @POST
    @jakarta.ws.rs.POST
    @Produces(value={"application/json"})
    @jakarta.ws.rs.Produces(value={"application/json"})
    @Path(value="{branch:([^/]+|[^@]+(@|%40)[^@/]*)}/history/transplant")
    @jakarta.ws.rs.Path(value="{branch:([^/]+|[^@]+(@|%40)[^@/]*)}/history/transplant")
    @Operation(summary="Transplant commits specified by the 'Transplant' payload object onto the given 'branch'", description="This is done as an atomic operation such that only the last of the sequence is ever visible to concurrent readers/writers. The sequence to transplant must be contiguous and in order.\n\nThe state of contents specified by the 'branch' reference will be used for detecting conflicts with the commits being transplanted.", operationId="transplantV2")
    @APIResponses(value={@APIResponse(responseCode="200", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="mergeResponseSuccess"), @ExampleObject(ref="mergeResponseFail")}, schema=@Schema(implementation=MergeResponse.class))}, description="Transplant operation completed. The actual transplant might have failed and reported as successful=false, if the client asked to return a conflict as a result instead of returning an error. Note: the 'commonAncestor' field in a response will always be null for a transplant."), @APIResponse(responseCode="400", description="Invalid input, ref/hash name not valid"), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to view the given reference or transplant commits"), @APIResponse(responseCode="404", description="Ref doesn't exists"), @APIResponse(responseCode="409", description="update conflict")})
    @JsonView(value={Views.V2.class})
    public MergeResponse transplantCommitsIntoBranch(@Parameter(schema=@Schema(pattern="([^/]+|[^@]+(@|%40)[^@/]*)"), description="A reference to a specific version of the contents tree (a point in history) on a branch.\nThis reference is specified in this form:\n- name@hash - Identifies the 'hash' commit on the named branch.\n\nThe 'hash' commit must be reachable from the current HEAD of the branch.\nIn this case 'hash' indicates the state of contents known to the client and serves to ensure that the operation is performed on the contents that the client expects.\nThis hash can point to a commit in the middle of the change history, but it should be as recent as possible.\n", examples={@ExampleObject(ref="refWithHash")}) @javax.ws.rs.PathParam(value="branch") @PathParam(value="branch") String var1, @RequestBody(required=true, description="Commits to transplant", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="transplant")})}) Transplant var2) throws NessieNotFoundException, NessieConflictException;

    @Override
    @POST
    @jakarta.ws.rs.POST
    @Produces(value={"application/json"})
    @jakarta.ws.rs.Produces(value={"application/json"})
    @Path(value="{branch:([^/]+|[^@]+(@|%40)[^@/]*)}/history/merge")
    @jakarta.ws.rs.Path(value="{branch:([^/]+|[^@]+(@|%40)[^@/]*)}/history/merge")
    @Operation(summary="Merge commits from another reference onto 'branch'.", description="Merge commits referenced by the 'mergeRefName' and 'fromHash' parameters of the payload object into the requested 'branch'.\n\nThe state of contents specified by the 'branch' reference will be used for detecting conflicts with the commits being transplanted.\n\nThe merge is committed if it is free from conflicts. The set of commits merged into the target branch will be all of those starting at 'fromHash' on 'mergeRefName' until we arrive at the common ancestor. Depending on the underlying implementation, the number of commits allowed as part of this operation may be limited.", operationId="mergeV2")
    @APIResponses(value={@APIResponse(responseCode="204", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="mergeResponseSuccess"), @ExampleObject(ref="mergeResponseFail")}, schema=@Schema(implementation=MergeResponse.class))}, description="Merge operation completed. The actual merge might have failed and reported as successful=false, if the client asked to return a conflict as a result instead of returning an error."), @APIResponse(responseCode="400", description="Invalid input, ref/hash name not valid"), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to view the given reference or merge commits"), @APIResponse(responseCode="404", description="Ref doesn't exists"), @APIResponse(responseCode="409", description="update conflict")})
    @JsonView(value={Views.V2.class})
    public MergeResponse mergeRefIntoBranch(@Parameter(schema=@Schema(pattern="([^/]+|[^@]+(@|%40)[^@/]*)"), description="A reference to a specific version of the contents tree (a point in history) on a branch.\nThis reference is specified in this form:\n- name@hash - Identifies the 'hash' commit on the named branch.\n\nThe 'hash' commit must be reachable from the current HEAD of the branch.\nIn this case 'hash' indicates the state of contents known to the client and serves to ensure that the operation is performed on the contents that the client expects.\nThis hash can point to a commit in the middle of the change history, but it should be as recent as possible.\n", examples={@ExampleObject(ref="refWithHash")}) @javax.ws.rs.PathParam(value="branch") @PathParam(value="branch") String var1, @RequestBody(required=true, description="Merge operation that defines the source reference name and an optional hash. If 'fromHash' is not present, the current 'sourceRef's HEAD will be used.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="merge")})}) Merge var2) throws NessieNotFoundException, NessieConflictException;

    @Override
    @POST
    @jakarta.ws.rs.POST
    @Path(value="{branch:([^/]+|[^@]+(@|%40)[^@/]*)}/history/commit")
    @jakarta.ws.rs.Path(value="{branch:([^/]+|[^@]+(@|%40)[^@/]*)}/history/commit")
    @Produces(value={"application/json"})
    @jakarta.ws.rs.Produces(value={"application/json"})
    @javax.ws.rs.Consumes(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Commit one or more operations against the given 'branch'.", description="The state of contents specified by the 'branch' reference will be used for detecting conflicts with the operation being committed.\n\nThe hash in the successful response will be the hash of the commit that contains the requested operations, whose immediate parent commit will be the current HEAD of the specified branch.", operationId="commitV2")
    @APIResponses(value={@APIResponse(responseCode="200", description="Updated successfully.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="commitResponse")}, schema=@Schema(implementation=CommitResponse.class))}), @APIResponse(responseCode="400", description="Invalid input, ref/hash name not valid"), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to view the given reference or perform commits"), @APIResponse(responseCode="404", description="Provided ref doesn't exist"), @APIResponse(responseCode="409", description="Update conflict")})
    @JsonView(value={Views.V2.class})
    public CommitResponse commitMultipleOperations(@Parameter(schema=@Schema(pattern="([^/]+|[^@]+(@|%40)[^@/]*)"), description="A reference to a particular version of the contents tree (a point in history) on a branch.\nThis reference is specified in this form:\n- name@hash - Identifies the 'hash' commit on the named branch.\n\nThe 'hash' commit must be reachable from the current HEAD of the branch.\nIn this case 'hash' indicates the state of contents that should be used for validating incoming changes.\n", examples={@ExampleObject(ref="refWithHash")}) @javax.ws.rs.PathParam(value="branch") @PathParam(value="branch") String var1, @RequestBody(required=true, description="Operations to commit", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="operations")})}) Operations var2) throws NessieNotFoundException, NessieConflictException;
}

