/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model.types;

import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import org.projectnessie.model.RepositoryConfig;
import org.projectnessie.model.types.RepositoryConfigTypeBundle;
import org.projectnessie.model.types.RepositoryConfigTypeRegistry;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class RepositoryConfigTypes {
    public static RepositoryConfig.Type[] all() {
        return Registry.all();
    }

    @javax.annotation.Nonnull
    @Nonnull
    public static RepositoryConfig.Type forName(String name) {
        return Registry.forName(name);
    }

    private static final class DefaultRepositoryConfigTypeImpl
    implements RepositoryConfig.Type {
        private DefaultRepositoryConfigTypeImpl() {
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return this.name();
        }

        @Override
        public String name() {
            return "UNKNOWN";
        }

        @Override
        public Class<? extends RepositoryConfig> type() {
            throw new IllegalStateException("UNKNOWN RepositoryConfig.Type has no type");
        }
    }

    private static final class RepositoryConfigTypeImpl
    implements RepositoryConfig.Type {
        private final String name;
        private final Class<? extends RepositoryConfig> type;

        private RepositoryConfigTypeImpl(String name, Class<? extends RepositoryConfig> type) {
            this.name = name;
            this.type = type;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Class<? extends RepositoryConfig> type() {
            return this.type;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RepositoryConfigTypeImpl)) {
                return false;
            }
            RepositoryConfigTypeImpl that = (RepositoryConfigTypeImpl)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private static final class Registry {
        private static final RepositoryConfig.Type[] all;
        private static final Map<String, RepositoryConfig.Type> byName;

        private Registry() {
        }

        private static RepositoryConfig.Type[] all() {
            return (RepositoryConfig.Type[])all.clone();
        }

        private static RepositoryConfig.Type forName(String name) {
            RepositoryConfig.Type type = byName.get(name);
            if (type == null) {
                throw new IllegalArgumentException("No repository config type registered for name " + name);
            }
            return type;
        }

        static {
            RegistryHelper registryHelper = new RegistryHelper();
            DefaultRepositoryConfigTypeImpl unknownRepositoryConfigType = new DefaultRepositoryConfigTypeImpl();
            registryHelper.add(unknownRepositoryConfigType);
            for (RepositoryConfigTypeBundle bundle : ServiceLoader.load(RepositoryConfigTypeBundle.class)) {
                bundle.register(registryHelper);
            }
            byName = Collections.unmodifiableMap(registryHelper.names);
            all = registryHelper.list.toArray(new RepositoryConfig.Type[0]);
        }
    }

    static final class RegistryHelper
    implements RepositoryConfigTypeRegistry {
        private final List<RepositoryConfig.Type> list = new ArrayList<RepositoryConfig.Type>();
        private final Map<String, RepositoryConfig.Type> names = new HashMap<String, RepositoryConfig.Type>();

        RegistryHelper() {
        }

        @Override
        public void register(Class<? extends RepositoryConfig> type) {
            Objects.requireNonNull(type, "Illegal repository config type registration: type must not be null");
            JsonTypeName jsonTypeName = type.getAnnotation(JsonTypeName.class);
            if (jsonTypeName == null) {
                throw new IllegalArgumentException(String.format("Repository config type registration: %s has no @JsonTypeName annotation", type.getName()));
            }
            String name = jsonTypeName.value();
            if (name == null || name.trim().isEmpty() || !name.trim().equals(name)) {
                throw new IllegalArgumentException(String.format("Illegal repository config type registration: illegal name '%s' for %s", name, type.getName()));
            }
            RepositoryConfigTypeImpl repositoryConfigType = new RepositoryConfigTypeImpl(name, type);
            RepositoryConfig.Type ex = this.names.get(name);
            if (ex != null) {
                throw new IllegalStateException(String.format("Duplicate repository config type registration for %s/%s, existing: %s/%s", name, type.getName(), ex.name(), ex.type().getName()));
            }
            this.add(repositoryConfigType);
        }

        void add(RepositoryConfig.Type unknownRepositoryConfigType) {
            this.list.add(unknownRepositoryConfigType);
            this.names.put(unknownRepositoryConfigType.name(), unknownRepositoryConfigType);
        }
    }
}

