/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.IcebergContent;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.ser.Views;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ParametersAreNonnullByDefault
@Generated(from="IcebergTable", generator="Immutables")
@Immutable
public final class ImmutableIcebergTable
extends IcebergTable {
    @Nullable
    private final String id;
    private final String metadataLocation;
    private final long snapshotId;
    private final int schemaId;
    private final int specId;
    private final int sortOrderId;
    @Nullable
    private final Map<String, Object> metadata;

    private ImmutableIcebergTable(@Nullable String id, String metadataLocation, long snapshotId, int schemaId, int specId, int sortOrderId, @Nullable Map<String, Object> metadata) {
        this.id = id;
        this.metadataLocation = metadataLocation;
        this.snapshotId = snapshotId;
        this.schemaId = schemaId;
        this.specId = specId;
        this.sortOrderId = sortOrderId;
        this.metadata = metadata;
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="metadataLocation")
    public String getMetadataLocation() {
        return this.metadataLocation;
    }

    @Override
    @JsonProperty(value="snapshotId")
    public long getSnapshotId() {
        return this.snapshotId;
    }

    @Override
    @JsonProperty(value="schemaId")
    public int getSchemaId() {
        return this.schemaId;
    }

    @Override
    @JsonProperty(value="specId")
    public int getSpecId() {
        return this.specId;
    }

    @Override
    @JsonProperty(value="sortOrderId")
    public int getSortOrderId() {
        return this.sortOrderId;
    }

    @Override
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonView(value={Views.V1.class})
    @Deprecated
    @Nullable
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Override
    public final ImmutableIcebergTable withId(@Nullable String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableIcebergTable(value, this.metadataLocation, this.snapshotId, this.schemaId, this.specId, this.sortOrderId, this.metadata);
    }

    public final ImmutableIcebergTable withMetadataLocation(String value) {
        String newValue = Objects.requireNonNull(value, "metadataLocation");
        if (this.metadataLocation.equals(newValue)) {
            return this;
        }
        return new ImmutableIcebergTable(this.id, newValue, this.snapshotId, this.schemaId, this.specId, this.sortOrderId, this.metadata);
    }

    public final ImmutableIcebergTable withSnapshotId(long value) {
        if (this.snapshotId == value) {
            return this;
        }
        return new ImmutableIcebergTable(this.id, this.metadataLocation, value, this.schemaId, this.specId, this.sortOrderId, this.metadata);
    }

    public final ImmutableIcebergTable withSchemaId(int value) {
        if (this.schemaId == value) {
            return this;
        }
        return new ImmutableIcebergTable(this.id, this.metadataLocation, this.snapshotId, value, this.specId, this.sortOrderId, this.metadata);
    }

    public final ImmutableIcebergTable withSpecId(int value) {
        if (this.specId == value) {
            return this;
        }
        return new ImmutableIcebergTable(this.id, this.metadataLocation, this.snapshotId, this.schemaId, value, this.sortOrderId, this.metadata);
    }

    public final ImmutableIcebergTable withSortOrderId(int value) {
        if (this.sortOrderId == value) {
            return this;
        }
        return new ImmutableIcebergTable(this.id, this.metadataLocation, this.snapshotId, this.schemaId, this.specId, value, this.metadata);
    }

    @Deprecated
    public final ImmutableIcebergTable withMetadata(@Nullable Map<String, ? extends Object> entries) {
        if (this.metadata == entries) {
            return this;
        }
        Map<String, Object> newValue = entries == null ? null : ImmutableIcebergTable.createUnmodifiableMap(true, false, entries);
        return new ImmutableIcebergTable(this.id, this.metadataLocation, this.snapshotId, this.schemaId, this.specId, this.sortOrderId, newValue);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIcebergTable && this.equalTo(0, (ImmutableIcebergTable)another);
    }

    private boolean equalTo(int synthetic, ImmutableIcebergTable another) {
        return Objects.equals(this.id, another.id) && this.metadataLocation.equals(another.metadataLocation) && this.snapshotId == another.snapshotId && this.schemaId == another.schemaId && this.specId == another.specId && this.sortOrderId == another.sortOrderId && Objects.equals(this.metadata, another.metadata);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.metadataLocation.hashCode();
        h += (h << 5) + Long.hashCode(this.snapshotId);
        h += (h << 5) + this.schemaId;
        h += (h << 5) + this.specId;
        h += (h << 5) + this.sortOrderId;
        h += (h << 5) + Objects.hashCode(this.metadata);
        return h;
    }

    public String toString() {
        return "IcebergTable{id=" + this.id + ", metadataLocation=" + this.metadataLocation + ", snapshotId=" + this.snapshotId + ", schemaId=" + this.schemaId + ", specId=" + this.specId + ", sortOrderId=" + this.sortOrderId + ", metadata=" + this.metadata + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableIcebergTable fromJson(Json json) {
        Builder builder = ImmutableIcebergTable.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.metadataLocation != null) {
            builder.metadataLocation(json.metadataLocation);
        }
        if (json.snapshotIdIsSet) {
            builder.snapshotId(json.snapshotId);
        }
        if (json.schemaIdIsSet) {
            builder.schemaId(json.schemaId);
        }
        if (json.specIdIsSet) {
            builder.specId(json.specId);
        }
        if (json.sortOrderIdIsSet) {
            builder.sortOrderId(json.sortOrderId);
        }
        if (json.metadata != null) {
            builder.putAllMetadata(json.metadata);
        }
        return builder.build();
    }

    public static ImmutableIcebergTable copyOf(IcebergTable instance) {
        if (instance instanceof ImmutableIcebergTable) {
            return (ImmutableIcebergTable)instance;
        }
        return ImmutableIcebergTable.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Generated(from="IcebergTable", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_METADATA_LOCATION = 1L;
        private static final long INIT_BIT_SNAPSHOT_ID = 2L;
        private static final long INIT_BIT_SCHEMA_ID = 4L;
        private static final long INIT_BIT_SPEC_ID = 8L;
        private static final long INIT_BIT_SORT_ORDER_ID = 16L;
        private long initBits = 31L;
        @javax.annotation.Nullable
        private String id;
        @javax.annotation.Nullable
        private String metadataLocation;
        private long snapshotId;
        private int schemaId;
        private int specId;
        private int sortOrderId;
        private Map<String, Object> metadata = null;

        private Builder() {
        }

        public final Builder from(IcebergTable instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Content instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IcebergContent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String idValue;
            Content instance;
            long bits = 0L;
            if (object instanceof IcebergTable) {
                instance = (IcebergTable)object;
                this.specId(((IcebergTable)instance).getSpecId());
                this.sortOrderId(((IcebergTable)instance).getSortOrderId());
                this.metadataLocation(((IcebergTable)instance).getMetadataLocation());
                Map<String, Object> metadataValue = ((IcebergTable)instance).getMetadata();
                if (metadataValue != null) {
                    this.putAllMetadata(metadataValue);
                }
                this.snapshotId(((IcebergTable)instance).getSnapshotId());
                this.schemaId(((IcebergTable)instance).getSchemaId());
            }
            if (object instanceof Content) {
                instance = (Content)object;
                if ((bits & 1L) == 0L) {
                    idValue = instance.getId();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof IcebergContent) {
                instance = (IcebergContent)object;
                if ((bits & 1L) == 0L) {
                    idValue = instance.getId();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @JsonProperty(value="id")
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="metadataLocation")
        public final Builder metadataLocation(String metadataLocation) {
            this.metadataLocation = Objects.requireNonNull(metadataLocation, "metadataLocation");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="snapshotId")
        public final Builder snapshotId(long snapshotId) {
            this.snapshotId = snapshotId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="schemaId")
        public final Builder schemaId(int schemaId) {
            this.schemaId = schemaId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="specId")
        public final Builder specId(int specId) {
            this.specId = specId;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="sortOrderId")
        public final Builder sortOrderId(int sortOrderId) {
            this.sortOrderId = sortOrderId;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @Deprecated
        public final Builder putMetadata(String key, Object value) {
            if (this.metadata == null) {
                this.metadata = new LinkedHashMap<String, Object>();
            }
            this.metadata.put(Objects.requireNonNull(key, "metadata key"), value == null ? Objects.requireNonNull(value, "metadata value for key: " + key) : value);
            return this;
        }

        @Deprecated
        public final Builder putMetadata(Map.Entry<String, ? extends Object> entry) {
            Object v;
            if (this.metadata == null) {
                this.metadata = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            this.metadata.put(Objects.requireNonNull(k, "metadata key"), (v = entry.getValue()) == null ? Objects.requireNonNull(v, "metadata value for key: " + k) : v);
            return this;
        }

        @JsonProperty(value="metadata")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonView(value={Views.V1.class})
        @Deprecated
        public final Builder metadata(@Nullable Map<String, ? extends Object> entries) {
            if (entries == null) {
                this.metadata = null;
                return this;
            }
            this.metadata = new LinkedHashMap<String, Object>();
            return this.putAllMetadata(entries);
        }

        @Deprecated
        public final Builder putAllMetadata(Map<String, ? extends Object> entries) {
            if (this.metadata == null) {
                this.metadata = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                Object v;
                String k = e.getKey();
                this.metadata.put(Objects.requireNonNull(k, "metadata key"), (v = e.getValue()) == null ? Objects.requireNonNull(v, "metadata value for key: " + k) : v);
            }
            return this;
        }

        public ImmutableIcebergTable build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIcebergTable(this.id, this.metadataLocation, this.snapshotId, this.schemaId, this.specId, this.sortOrderId, this.metadata == null ? null : ImmutableIcebergTable.createUnmodifiableMap(false, false, this.metadata));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("metadataLocation");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("snapshotId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("schemaId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("specId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("sortOrderId");
            }
            return "Cannot build IcebergTable, some of required attributes are not set " + attributes;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="IcebergTable", generator="Immutables")
    static final class Json
    extends IcebergTable {
        @javax.annotation.Nullable
        String id;
        @javax.annotation.Nullable
        String metadataLocation;
        long snapshotId;
        boolean snapshotIdIsSet;
        int schemaId;
        boolean schemaIdIsSet;
        int specId;
        boolean specIdIsSet;
        int sortOrderId;
        boolean sortOrderIdIsSet;
        @javax.annotation.Nullable
        Map<String, Object> metadata = null;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="metadataLocation")
        public void setMetadataLocation(String metadataLocation) {
            this.metadataLocation = metadataLocation;
        }

        @JsonProperty(value="snapshotId")
        public void setSnapshotId(long snapshotId) {
            this.snapshotId = snapshotId;
            this.snapshotIdIsSet = true;
        }

        @JsonProperty(value="schemaId")
        public void setSchemaId(int schemaId) {
            this.schemaId = schemaId;
            this.schemaIdIsSet = true;
        }

        @JsonProperty(value="specId")
        public void setSpecId(int specId) {
            this.specId = specId;
            this.specIdIsSet = true;
        }

        @JsonProperty(value="sortOrderId")
        public void setSortOrderId(int sortOrderId) {
            this.sortOrderId = sortOrderId;
            this.sortOrderIdIsSet = true;
        }

        @JsonProperty(value="metadata")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonView(value={Views.V1.class})
        public void setMetadata(@Nullable Map<String, Object> metadata) {
            this.metadata = metadata;
        }

        @Override
        public IcebergTable withId(String id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMetadataLocation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getSnapshotId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getSchemaId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getSpecId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getSortOrderId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

