/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.Documentation;
import org.projectnessie.model.ImmutableContentWithKey;
import org.projectnessie.model.ImmutableGetMultipleContentsResponse;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ser.Views;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Schema(type=SchemaType.OBJECT, title="GetMultipleContentsResponse")
@JsonSerialize(as=ImmutableGetMultipleContentsResponse.class)
@JsonDeserialize(as=ImmutableGetMultipleContentsResponse.class)
@Value.Immutable
public interface GetMultipleContentsResponse {
    @NotNull
    @jakarta.validation.constraints.NotNull
    @Value.Parameter(order=1)
    public List<ContentWithKey> getContents();

    @javax.annotation.Nullable
    @Nullable
    @JsonView(value={Views.V2.class})
    @Value.Parameter(order=2)
    public Reference getEffectiveReference();

    @Value.NonAttribute
    default public Map<ContentKey, Content> toContentsMap() {
        return this.getContents().stream().collect(Collectors.toMap(ContentWithKey::getKey, ContentWithKey::getContent));
    }

    public static GetMultipleContentsResponse of(List<ContentWithKey> items, Reference effectiveReference) {
        return ImmutableGetMultipleContentsResponse.of(items, effectiveReference);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @JsonSerialize(as=ImmutableContentWithKey.class)
    @JsonDeserialize(as=ImmutableContentWithKey.class)
    @Value.Immutable
    public static interface ContentWithKey {
        @NotNull
        @jakarta.validation.constraints.NotNull
        @Value.Parameter(order=1)
        public ContentKey getKey();

        @NotNull
        @jakarta.validation.constraints.NotNull
        @Value.Parameter(order=2)
        public Content getContent();

        @javax.annotation.Nullable
        @Nullable
        @JsonView(value={Views.V2.class})
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Value.Parameter(order=3)
        public Documentation getDocumentation();

        public static ContentWithKey of(ContentKey key, Content content) {
            return ContentWithKey.of(key, content, null);
        }

        public static ContentWithKey of(ContentKey key, Content content, Documentation documentation) {
            return ImmutableContentWithKey.of(key, content, documentation);
        }
    }
}

