/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ContentMetadata;
import org.projectnessie.model.Documentation;
import org.projectnessie.model.Operation;
import org.projectnessie.model.ser.Views;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ParametersAreNonnullByDefault
@Generated(from="Operation.Put", generator="Immutables")
@Immutable
public final class ImmutablePut
implements Operation.Put {
    private final ContentKey key;
    private final Content content;
    @Nullable
    private final Content expectedContent;
    private final List<ContentMetadata> metadata;
    @Nullable
    private final Documentation documentation;

    private ImmutablePut(ContentKey key, Content content, @Nullable Content expectedContent, List<ContentMetadata> metadata, @Nullable Documentation documentation) {
        this.key = key;
        this.content = content;
        this.expectedContent = expectedContent;
        this.metadata = metadata;
        this.documentation = documentation;
    }

    @Override
    @JsonProperty(value="key")
    public ContentKey getKey() {
        return this.key;
    }

    @Override
    @JsonProperty(value="content")
    public Content getContent() {
        return this.content;
    }

    @Override
    @JsonProperty(value="expectedContent")
    @JsonView(value={Views.V1.class})
    @Deprecated
    @Nullable
    public Content getExpectedContent() {
        return this.expectedContent;
    }

    @Override
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonView(value={Views.V2.class})
    public List<ContentMetadata> getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="documentation")
    @JsonView(value={Views.V2.class})
    @Nullable
    public Documentation getDocumentation() {
        return this.documentation;
    }

    public final ImmutablePut withKey(ContentKey value) {
        if (this.key == value) {
            return this;
        }
        ContentKey newValue = Objects.requireNonNull(value, "key");
        return new ImmutablePut(newValue, this.content, this.expectedContent, this.metadata, this.documentation);
    }

    public final ImmutablePut withContent(Content value) {
        if (this.content == value) {
            return this;
        }
        Content newValue = Objects.requireNonNull(value, "content");
        return new ImmutablePut(this.key, newValue, this.expectedContent, this.metadata, this.documentation);
    }

    @Deprecated
    public final ImmutablePut withExpectedContent(@Nullable Content value) {
        if (this.expectedContent == value) {
            return this;
        }
        return new ImmutablePut(this.key, this.content, value, this.metadata, this.documentation);
    }

    public final ImmutablePut withMetadata(ContentMetadata ... elements) {
        List<ContentMetadata> newValue = ImmutablePut.createUnmodifiableList(false, ImmutablePut.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePut(this.key, this.content, this.expectedContent, newValue, this.documentation);
    }

    public final ImmutablePut withMetadata(Iterable<? extends ContentMetadata> elements) {
        if (this.metadata == elements) {
            return this;
        }
        List<ContentMetadata> newValue = ImmutablePut.createUnmodifiableList(false, ImmutablePut.createSafeList(elements, true, false));
        return new ImmutablePut(this.key, this.content, this.expectedContent, newValue, this.documentation);
    }

    public final ImmutablePut withDocumentation(@Nullable Documentation value) {
        if (this.documentation == value) {
            return this;
        }
        return new ImmutablePut(this.key, this.content, this.expectedContent, this.metadata, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePut && this.equalTo(0, (ImmutablePut)another);
    }

    private boolean equalTo(int synthetic, ImmutablePut another) {
        return this.key.equals(another.key) && this.content.equals(another.content) && Objects.equals(this.expectedContent, another.expectedContent) && this.metadata.equals(another.metadata) && Objects.equals(this.documentation, another.documentation);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.content.hashCode();
        h += (h << 5) + Objects.hashCode(this.expectedContent);
        h += (h << 5) + this.metadata.hashCode();
        h += (h << 5) + Objects.hashCode(this.documentation);
        return h;
    }

    public String toString() {
        return "Put{key=" + this.key + ", content=" + this.content + ", expectedContent=" + this.expectedContent + ", metadata=" + this.metadata + ", documentation=" + this.documentation + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePut fromJson(Json json) {
        Builder builder = ImmutablePut.builder();
        if (json.key != null) {
            builder.key(json.key);
        }
        if (json.content != null) {
            builder.content(json.content);
        }
        if (json.expectedContent != null) {
            builder.expectedContent(json.expectedContent);
        }
        if (json.metadata != null) {
            builder.addAllMetadata(json.metadata);
        }
        if (json.documentation != null) {
            builder.documentation(json.documentation);
        }
        return builder.build();
    }

    public static ImmutablePut copyOf(Operation.Put instance) {
        if (instance instanceof ImmutablePut) {
            return (ImmutablePut)instance;
        }
        return ImmutablePut.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Generated(from="Operation.Put", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_CONTENT = 2L;
        private long initBits = 3L;
        @javax.annotation.Nullable
        private ContentKey key;
        @javax.annotation.Nullable
        private Content content;
        @javax.annotation.Nullable
        private Content expectedContent;
        private List<ContentMetadata> metadata = new ArrayList<ContentMetadata>();
        @javax.annotation.Nullable
        private Documentation documentation;

        private Builder() {
        }

        public final Builder from(Operation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(Operation.Put instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Operation instance;
            long bits = 0L;
            if (object instanceof Operation) {
                instance = (Operation)object;
                if ((bits & 1L) == 0L) {
                    this.key(instance.getKey());
                    bits |= 1L;
                }
            }
            if (object instanceof Operation.Put) {
                Content expectedContentValue;
                instance = (Operation.Put)object;
                this.addAllMetadata(instance.getMetadata());
                if ((bits & 1L) == 0L) {
                    this.key(instance.getKey());
                    bits |= 1L;
                }
                this.content(instance.getContent());
                Documentation documentationValue = instance.getDocumentation();
                if (documentationValue != null) {
                    this.documentation(documentationValue);
                }
                if ((expectedContentValue = instance.getExpectedContent()) != null) {
                    this.expectedContent(expectedContentValue);
                }
            }
        }

        @JsonProperty(value="key")
        public final Builder key(ContentKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="content")
        public final Builder content(Content content) {
            this.content = Objects.requireNonNull(content, "content");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="expectedContent")
        @JsonView(value={Views.V1.class})
        @Deprecated
        public final Builder expectedContent(@Nullable Content expectedContent) {
            this.expectedContent = expectedContent;
            return this;
        }

        public final Builder addMetadata(ContentMetadata element) {
            this.metadata.add(Objects.requireNonNull(element, "metadata element"));
            return this;
        }

        public final Builder addMetadata(ContentMetadata ... elements) {
            for (ContentMetadata element : elements) {
                this.metadata.add(Objects.requireNonNull(element, "metadata element"));
            }
            return this;
        }

        @JsonProperty(value="metadata")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonView(value={Views.V2.class})
        public final Builder metadata(Iterable<? extends ContentMetadata> elements) {
            this.metadata.clear();
            return this.addAllMetadata(elements);
        }

        public final Builder addAllMetadata(Iterable<? extends ContentMetadata> elements) {
            for (ContentMetadata contentMetadata : elements) {
                this.metadata.add(Objects.requireNonNull(contentMetadata, "metadata element"));
            }
            return this;
        }

        @JsonProperty(value="documentation")
        @JsonView(value={Views.V2.class})
        public final Builder documentation(@Nullable Documentation documentation) {
            this.documentation = documentation;
            return this;
        }

        public ImmutablePut build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePut(this.key, this.content, this.expectedContent, ImmutablePut.createUnmodifiableList(true, this.metadata), this.documentation);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("content");
            }
            return "Cannot build Put, some of required attributes are not set " + attributes;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Operation.Put", generator="Immutables")
    static final class Json
    implements Operation.Put {
        @javax.annotation.Nullable
        ContentKey key;
        @javax.annotation.Nullable
        Content content;
        @javax.annotation.Nullable
        Content expectedContent;
        @javax.annotation.Nullable
        List<ContentMetadata> metadata = Collections.emptyList();
        @javax.annotation.Nullable
        Documentation documentation;

        Json() {
        }

        @JsonProperty(value="key")
        public void setKey(ContentKey key) {
            this.key = key;
        }

        @JsonProperty(value="content")
        public void setContent(Content content) {
            this.content = content;
        }

        @JsonProperty(value="expectedContent")
        @JsonView(value={Views.V1.class})
        public void setExpectedContent(@Nullable Content expectedContent) {
            this.expectedContent = expectedContent;
        }

        @JsonProperty(value="metadata")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonView(value={Views.V2.class})
        public void setMetadata(List<ContentMetadata> metadata) {
            this.metadata = metadata;
        }

        @JsonProperty(value="documentation")
        @JsonView(value={Views.V2.class})
        public void setDocumentation(@Nullable Documentation documentation) {
            this.documentation = documentation;
        }

        @Override
        public ContentKey getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Content getContent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Content getExpectedContent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ContentMetadata> getMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Documentation getDocumentation() {
            throw new UnsupportedOperationException();
        }
    }
}

