/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v2.params;

import java.util.function.Supplier;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.projectnessie.api.v2.params.ParsedReference;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Validation;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ReferenceResolver {
    private static final String DEFAULT_REF_IN_PATH = "-";

    private ReferenceResolver() {
    }

    public static ParsedReference resolveReferencePathElement(@Nonnull String refPathString, @Nullable Reference.ReferenceType namedRefType, @Nonnull Supplier<String> defaultBranchSupplier) {
        Matcher refNameMatcher = Validation.REF_NAME_PATH_PATTERN.matcher(refPathString);
        if (!refNameMatcher.find()) {
            throw new IllegalArgumentException("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'");
        }
        String name = refNameMatcher.group(1);
        if (DEFAULT_REF_IN_PATH.equals(name)) {
            name = defaultBranchSupplier.get();
        }
        String hash = refNameMatcher.group(2);
        String relativeSpec = refNameMatcher.group(3);
        if (hash != null && relativeSpec != null) {
            hash = hash + relativeSpec;
        } else if (relativeSpec != null) {
            hash = relativeSpec;
        }
        return ParsedReference.parsedReference(name, hash, name != null ? namedRefType : null);
    }
}

