/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.immutables.value.Value;
import org.projectnessie.model.ImmutableTableReference;
import org.projectnessie.model.Validation;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Value.Immutable
public abstract class TableReference {
    static final String ILLEGAL_TABLE_REFERENCE_MESSAGE = "Illegal table reference syntax, '%s' must match the syntax 'table-identifier ( '@' reference-name )? ( '#' hashOrTimestamp )?', optionally enclosed by backticks or single-quotes.";
    private static final Pattern TABLE_REFERENCE_PATTERN = Pattern.compile("^([^@#]+)(@([^@#]+))?(#([^@#]+))?$");

    @NotNull
    @NotEmpty
    public abstract String getName();

    @Nullable
    @NotEmpty
    public abstract String getReference();

    @Value.Redacted
    public boolean hasReference() {
        return this.getReference() != null;
    }

    @Nullable
    @NotEmpty
    public abstract String getTimestamp();

    @Value.Redacted
    public boolean hasTimestamp() {
        return this.getTimestamp() != null;
    }

    @Nullable
    @NotEmpty
    public abstract String getHash();

    @Value.Redacted
    public boolean hasHash() {
        return this.getHash() != null;
    }

    public String toString() {
        if (this.hasReference() || this.hasTimestamp() || this.hasHash()) {
            StringBuilder sb = new StringBuilder();
            sb.append('`').append(this.getName());
            if (this.hasReference()) {
                sb.append('@').append(this.getReference());
            }
            if (this.hasHash()) {
                sb.append('#').append(this.getHash());
            } else if (this.hasTimestamp()) {
                sb.append('#').append(this.getTimestamp());
            }
            sb.append('`');
            return sb.toString();
        }
        return this.getName();
    }

    public static TableReference parse(String tableReference) {
        String unquoted = TableReference.unquote(tableReference);
        Matcher matcher = TABLE_REFERENCE_PATTERN.matcher(unquoted);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format(ILLEGAL_TABLE_REFERENCE_MESSAGE, tableReference));
        }
        String table = matcher.group(1);
        String refName = matcher.group(3);
        String hashOrTimestamp = matcher.group(5);
        if (refName != null) {
            Validation.validateReferenceName(refName);
        }
        ImmutableTableReference.Builder b = ImmutableTableReference.builder().name(table);
        if (refName != null) {
            b.reference(refName);
        }
        if (hashOrTimestamp != null) {
            if (Validation.isValidHashOrRelativeSpec(hashOrTimestamp)) {
                b.hash(hashOrTimestamp);
            } else {
                b.timestamp(hashOrTimestamp);
            }
        }
        return b.build();
    }

    private static String unquote(String maybeQuoted) {
        if (maybeQuoted.startsWith("`") && maybeQuoted.endsWith("`") || maybeQuoted.startsWith("'") && maybeQuoted.endsWith("'")) {
            return maybeQuoted.substring(1, maybeQuoted.length() - 1);
        }
        return maybeQuoted;
    }
}

