/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v1.params;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import javax.validation.constraints.Size;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.media.SchemaProperty;
import org.immutables.value.Value;
import org.projectnessie.api.v1.params.BaseMergeTransplant;
import org.projectnessie.api.v1.params.ImmutableTransplant;
import org.projectnessie.model.Validation;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Schema(type=SchemaType.OBJECT, title="Transplant", properties={@SchemaProperty(name="fromRefName", pattern="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$"), @SchemaProperty(name="hashesToTransplant", uniqueItems=true)})
@JsonSerialize(as=ImmutableTransplant.class)
@JsonDeserialize(as=ImmutableTransplant.class)
@Value.Immutable
public interface Transplant
extends BaseMergeTransplant {
    @javax.validation.constraints.NotNull
    @NotNull
    @Size
    @jakarta.validation.constraints.Size(min=1)
    public @javax.validation.constraints.NotNull @NotNull @Size @jakarta.validation.constraints.Size(min=1) List<String> getHashesToTransplant();

    @Value.Check
    default public void checkHashes() {
        List<String> hashes = this.getHashesToTransplant();
        if (hashes != null) {
            for (String hash : hashes) {
                Validation.validateHash(hash);
            }
        }
    }
}

