/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.error;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.error.NessieError;
import org.projectnessie.error.NessieErrorDetails;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="NessieError", generator="Immutables")
@Immutable
public final class ImmutableNessieError
implements NessieError {
    private final int status;
    private final String reason;
    private final String message;
    private final ErrorCode errorCode;
    @Nullable
    private final NessieErrorDetails errorDetails;
    @Nullable
    private final String serverStackTrace;
    @Nullable
    private final Exception clientProcessingException;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableNessieError(Builder builder) {
        this.status = builder.status;
        this.reason = builder.reason;
        this.errorDetails = builder.errorDetails;
        this.serverStackTrace = builder.serverStackTrace;
        this.clientProcessingException = builder.clientProcessingException;
        if (builder.message != null) {
            this.initShim.message(builder.message);
        }
        if (builder.errorCode != null) {
            this.initShim.errorCode(builder.errorCode);
        }
        this.message = this.initShim.getMessage();
        this.errorCode = this.initShim.getErrorCode();
        this.initShim = null;
    }

    private ImmutableNessieError(int status, String reason, String message, ErrorCode errorCode, @Nullable NessieErrorDetails errorDetails, @Nullable String serverStackTrace, @Nullable Exception clientProcessingException) {
        this.status = status;
        this.reason = reason;
        this.message = message;
        this.errorCode = errorCode;
        this.errorDetails = errorDetails;
        this.serverStackTrace = serverStackTrace;
        this.clientProcessingException = clientProcessingException;
        this.initShim = null;
    }

    private String getMessageInitialize() {
        return NessieError.super.getMessage();
    }

    private ErrorCode getErrorCodeInitialize() {
        return NessieError.super.getErrorCode();
    }

    @Override
    @JsonProperty(value="status")
    public int getStatus() {
        return this.status;
    }

    @Override
    @JsonProperty(value="reason")
    public String getReason() {
        return this.reason;
    }

    @Override
    @JsonProperty(value="message")
    public String getMessage() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMessage() : this.message;
    }

    @Override
    @JsonProperty(value="errorCode")
    @JsonDeserialize(using=ErrorCode.Deserializer.class)
    public ErrorCode getErrorCode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getErrorCode() : this.errorCode;
    }

    @Override
    @JsonProperty(value="errorDetails")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public NessieErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    @Override
    @JsonProperty(value="serverStackTrace")
    @Nullable
    public String getServerStackTrace() {
        return this.serverStackTrace;
    }

    @Override
    @JsonProperty(value="clientProcessingException")
    @JsonIgnore
    @Nullable
    public Exception getClientProcessingException() {
        return this.clientProcessingException;
    }

    public final ImmutableNessieError withStatus(int value) {
        if (this.status == value) {
            return this;
        }
        return new ImmutableNessieError(value, this.reason, this.message, this.errorCode, this.errorDetails, this.serverStackTrace, this.clientProcessingException);
    }

    public final ImmutableNessieError withReason(String value) {
        String newValue = Objects.requireNonNull(value, "reason");
        if (this.reason.equals(newValue)) {
            return this;
        }
        return new ImmutableNessieError(this.status, newValue, this.message, this.errorCode, this.errorDetails, this.serverStackTrace, this.clientProcessingException);
    }

    public final ImmutableNessieError withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableNessieError(this.status, this.reason, newValue, this.errorCode, this.errorDetails, this.serverStackTrace, this.clientProcessingException);
    }

    public final ImmutableNessieError withErrorCode(ErrorCode value) {
        ErrorCode newValue = Objects.requireNonNull(value, "errorCode");
        if (this.errorCode == newValue) {
            return this;
        }
        return new ImmutableNessieError(this.status, this.reason, this.message, newValue, this.errorDetails, this.serverStackTrace, this.clientProcessingException);
    }

    public final ImmutableNessieError withErrorDetails(@Nullable NessieErrorDetails value) {
        if (this.errorDetails == value) {
            return this;
        }
        return new ImmutableNessieError(this.status, this.reason, this.message, this.errorCode, value, this.serverStackTrace, this.clientProcessingException);
    }

    public final ImmutableNessieError withServerStackTrace(@Nullable String value) {
        if (Objects.equals(this.serverStackTrace, value)) {
            return this;
        }
        return new ImmutableNessieError(this.status, this.reason, this.message, this.errorCode, this.errorDetails, value, this.clientProcessingException);
    }

    public final ImmutableNessieError withClientProcessingException(@Nullable Exception value) {
        if (this.clientProcessingException == value) {
            return this;
        }
        return new ImmutableNessieError(this.status, this.reason, this.message, this.errorCode, this.errorDetails, this.serverStackTrace, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNessieError && this.equalTo(0, (ImmutableNessieError)another);
    }

    private boolean equalTo(int synthetic, ImmutableNessieError another) {
        return this.status == another.status && this.reason.equals(another.reason) && this.message.equals(another.message) && this.errorCode.equals((Object)another.errorCode) && Objects.equals(this.errorDetails, another.errorDetails) && Objects.equals(this.serverStackTrace, another.serverStackTrace);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.status;
        h += (h << 5) + this.reason.hashCode();
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + this.errorCode.hashCode();
        h += (h << 5) + Objects.hashCode(this.errorDetails);
        h += (h << 5) + Objects.hashCode(this.serverStackTrace);
        return h;
    }

    public String toString() {
        return "NessieError{status=" + this.status + ", reason=" + this.reason + ", message=" + this.message + ", errorCode=" + (Object)((Object)this.errorCode) + ", errorDetails=" + this.errorDetails + ", serverStackTrace=" + this.serverStackTrace + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNessieError fromJson(Json json) {
        Builder builder = ImmutableNessieError.builder();
        if (json.statusIsSet) {
            builder.status(json.status);
        }
        if (json.reason != null) {
            builder.reason(json.reason);
        }
        if (json.message != null) {
            builder.message(json.message);
        }
        if (json.errorCode != null) {
            builder.errorCode(json.errorCode);
        }
        if (json.errorDetails != null) {
            builder.errorDetails(json.errorDetails);
        }
        if (json.serverStackTrace != null) {
            builder.serverStackTrace(json.serverStackTrace);
        }
        if (json.clientProcessingException != null) {
            builder.clientProcessingException(json.clientProcessingException);
        }
        return builder.build();
    }

    public static ImmutableNessieError copyOf(NessieError instance) {
        if (instance instanceof ImmutableNessieError) {
            return (ImmutableNessieError)instance;
        }
        return ImmutableNessieError.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Generated(from="NessieError", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_STATUS = 1L;
        private static final long INIT_BIT_REASON = 2L;
        private long initBits = 3L;
        private int status;
        @javax.annotation.Nullable
        private String reason;
        @javax.annotation.Nullable
        private String message;
        @javax.annotation.Nullable
        private ErrorCode errorCode;
        @javax.annotation.Nullable
        private NessieErrorDetails errorDetails;
        @javax.annotation.Nullable
        private String serverStackTrace;
        @javax.annotation.Nullable
        private Exception clientProcessingException;

        private Builder() {
        }

        public final Builder from(NessieError instance) {
            Exception clientProcessingExceptionValue;
            String serverStackTraceValue;
            Objects.requireNonNull(instance, "instance");
            this.status(instance.getStatus());
            this.reason(instance.getReason());
            this.message(instance.getMessage());
            this.errorCode(instance.getErrorCode());
            NessieErrorDetails errorDetailsValue = instance.getErrorDetails();
            if (errorDetailsValue != null) {
                this.errorDetails(errorDetailsValue);
            }
            if ((serverStackTraceValue = instance.getServerStackTrace()) != null) {
                this.serverStackTrace(serverStackTraceValue);
            }
            if ((clientProcessingExceptionValue = instance.getClientProcessingException()) != null) {
                this.clientProcessingException(clientProcessingExceptionValue);
            }
            return this;
        }

        @JsonProperty(value="status")
        public final Builder status(int status) {
            this.status = status;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="reason")
        public final Builder reason(String reason) {
            this.reason = Objects.requireNonNull(reason, "reason");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="message")
        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            return this;
        }

        @JsonProperty(value="errorCode")
        @JsonDeserialize(using=ErrorCode.Deserializer.class)
        public final Builder errorCode(ErrorCode errorCode) {
            this.errorCode = Objects.requireNonNull(errorCode, "errorCode");
            return this;
        }

        @JsonProperty(value="errorDetails")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public final Builder errorDetails(@Nullable NessieErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        @JsonProperty(value="serverStackTrace")
        public final Builder serverStackTrace(@Nullable String serverStackTrace) {
            this.serverStackTrace = serverStackTrace;
            return this;
        }

        @JsonProperty(value="clientProcessingException")
        @JsonIgnore
        public final Builder clientProcessingException(@Nullable Exception clientProcessingException) {
            this.clientProcessingException = clientProcessingException;
            return this;
        }

        public ImmutableNessieError build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNessieError(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("status");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("reason");
            }
            return "Cannot build NessieError, some of required attributes are not set " + attributes;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="NessieError", generator="Immutables")
    static final class Json
    implements NessieError {
        int status;
        boolean statusIsSet;
        @javax.annotation.Nullable
        String reason;
        @javax.annotation.Nullable
        String message;
        @javax.annotation.Nullable
        ErrorCode errorCode;
        @javax.annotation.Nullable
        NessieErrorDetails errorDetails;
        @javax.annotation.Nullable
        String serverStackTrace;
        @javax.annotation.Nullable
        Exception clientProcessingException;

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(int status) {
            this.status = status;
            this.statusIsSet = true;
        }

        @JsonProperty(value="reason")
        public void setReason(String reason) {
            this.reason = reason;
        }

        @JsonProperty(value="message")
        public void setMessage(String message) {
            this.message = message;
        }

        @JsonProperty(value="errorCode")
        @JsonDeserialize(using=ErrorCode.Deserializer.class)
        public void setErrorCode(ErrorCode errorCode) {
            this.errorCode = errorCode;
        }

        @JsonProperty(value="errorDetails")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setErrorDetails(@Nullable NessieErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
        }

        @JsonProperty(value="serverStackTrace")
        public void setServerStackTrace(@Nullable String serverStackTrace) {
            this.serverStackTrace = serverStackTrace;
        }

        @JsonProperty(value="clientProcessingException")
        @JsonIgnore
        public void setClientProcessingException(@Nullable Exception clientProcessingException) {
            this.clientProcessingException = clientProcessingException;
        }

        @Override
        public int getStatus() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getReason() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ErrorCode getErrorCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NessieErrorDetails getErrorDetails() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServerStackTrace() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Exception getClientProcessingException() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="NessieError", generator="Immutables")
    private final class InitShim {
        private byte messageBuildStage = 0;
        private String message;
        private byte errorCodeBuildStage = 0;
        private ErrorCode errorCode;

        private InitShim() {
        }

        String getMessage() {
            if (this.messageBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.messageBuildStage == 0) {
                this.messageBuildStage = (byte)-1;
                this.message = Objects.requireNonNull(ImmutableNessieError.this.getMessageInitialize(), "message");
                this.messageBuildStage = 1;
            }
            return this.message;
        }

        void message(String message) {
            this.message = message;
            this.messageBuildStage = 1;
        }

        ErrorCode getErrorCode() {
            if (this.errorCodeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.errorCodeBuildStage == 0) {
                this.errorCodeBuildStage = (byte)-1;
                this.errorCode = Objects.requireNonNull(ImmutableNessieError.this.getErrorCodeInitialize(), "errorCode");
                this.errorCodeBuildStage = 1;
            }
            return this.errorCode;
        }

        void errorCode(ErrorCode errorCode) {
            this.errorCode = errorCode;
            this.errorCodeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.messageBuildStage == -1) {
                attributes.add("message");
            }
            if (this.errorCodeBuildStage == -1) {
                attributes.add("errorCode");
            }
            return "Cannot build NessieError, attribute initializers form cycle " + attributes;
        }
    }
}

