/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.CommitConsistency;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ReferenceHistoryState;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ParametersAreNonnullByDefault
@Generated(from="ReferenceHistoryState", generator="Immutables")
@Immutable
public final class ImmutableReferenceHistoryState
implements ReferenceHistoryState {
    private final String commitHash;
    private final CommitConsistency commitConsistency;
    private final CommitMeta meta;

    private ImmutableReferenceHistoryState(String commitHash, CommitConsistency commitConsistency, CommitMeta meta) {
        this.commitHash = Objects.requireNonNull(commitHash, "commitHash");
        this.commitConsistency = Objects.requireNonNull(commitConsistency, "commitConsistency");
        this.meta = meta;
    }

    private ImmutableReferenceHistoryState(ImmutableReferenceHistoryState original, String commitHash, CommitConsistency commitConsistency, CommitMeta meta) {
        this.commitHash = commitHash;
        this.commitConsistency = commitConsistency;
        this.meta = meta;
    }

    @Override
    @JsonProperty(value="commitHash")
    public String commitHash() {
        return this.commitHash;
    }

    @Override
    @JsonProperty(value="commitConsistency")
    public CommitConsistency commitConsistency() {
        return this.commitConsistency;
    }

    @Override
    @JsonProperty(value="meta")
    public CommitMeta meta() {
        return this.meta;
    }

    public final ImmutableReferenceHistoryState withCommitHash(String value) {
        String newValue = Objects.requireNonNull(value, "commitHash");
        if (this.commitHash.equals(newValue)) {
            return this;
        }
        return new ImmutableReferenceHistoryState(this, newValue, this.commitConsistency, this.meta);
    }

    public final ImmutableReferenceHistoryState withCommitConsistency(CommitConsistency value) {
        CommitConsistency newValue = Objects.requireNonNull(value, "commitConsistency");
        if (this.commitConsistency == newValue) {
            return this;
        }
        return new ImmutableReferenceHistoryState(this, this.commitHash, newValue, this.meta);
    }

    public final ImmutableReferenceHistoryState withMeta(CommitMeta value) {
        if (this.meta == value) {
            return this;
        }
        return new ImmutableReferenceHistoryState(this, this.commitHash, this.commitConsistency, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReferenceHistoryState && this.equalTo(0, (ImmutableReferenceHistoryState)another);
    }

    private boolean equalTo(int synthetic, ImmutableReferenceHistoryState another) {
        return this.commitHash.equals(another.commitHash) && this.commitConsistency.equals((Object)another.commitConsistency) && Objects.equals(this.meta, another.meta);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.commitHash.hashCode();
        h += (h << 5) + this.commitConsistency.hashCode();
        h += (h << 5) + Objects.hashCode(this.meta);
        return h;
    }

    public String toString() {
        return "ReferenceHistoryState{commitHash=" + this.commitHash + ", commitConsistency=" + (Object)((Object)this.commitConsistency) + ", meta=" + this.meta + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableReferenceHistoryState fromJson(Json json) {
        Builder builder = ImmutableReferenceHistoryState.builder();
        if (json.commitHash != null) {
            builder.commitHash(json.commitHash);
        }
        if (json.commitConsistency != null) {
            builder.commitConsistency(json.commitConsistency);
        }
        if (json.meta != null) {
            builder.meta(json.meta);
        }
        return builder.build();
    }

    public static ImmutableReferenceHistoryState of(String commitHash, CommitConsistency commitConsistency, CommitMeta meta) {
        return new ImmutableReferenceHistoryState(commitHash, commitConsistency, meta);
    }

    public static ImmutableReferenceHistoryState copyOf(ReferenceHistoryState instance) {
        if (instance instanceof ImmutableReferenceHistoryState) {
            return (ImmutableReferenceHistoryState)instance;
        }
        return ImmutableReferenceHistoryState.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Generated(from="ReferenceHistoryState", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COMMIT_HASH = 1L;
        private static final long INIT_BIT_COMMIT_CONSISTENCY = 2L;
        private long initBits = 3L;
        @Nullable
        private String commitHash;
        @Nullable
        private CommitConsistency commitConsistency;
        @Nullable
        private CommitMeta meta;

        private Builder() {
        }

        public final Builder from(ReferenceHistoryState instance) {
            Objects.requireNonNull(instance, "instance");
            this.commitHash(instance.commitHash());
            this.commitConsistency(instance.commitConsistency());
            CommitMeta metaValue = instance.meta();
            if (metaValue != null) {
                this.meta(metaValue);
            }
            return this;
        }

        @JsonProperty(value="commitHash")
        public final Builder commitHash(String commitHash) {
            this.commitHash = Objects.requireNonNull(commitHash, "commitHash");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="commitConsistency")
        public final Builder commitConsistency(CommitConsistency commitConsistency) {
            this.commitConsistency = Objects.requireNonNull(commitConsistency, "commitConsistency");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="meta")
        public final Builder meta(CommitMeta meta) {
            this.meta = meta;
            return this;
        }

        public ImmutableReferenceHistoryState build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReferenceHistoryState(null, this.commitHash, this.commitConsistency, this.meta);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("commitHash");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("commitConsistency");
            }
            return "Cannot build ReferenceHistoryState, some of required attributes are not set " + attributes;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ReferenceHistoryState", generator="Immutables")
    static final class Json
    implements ReferenceHistoryState {
        @Nullable
        String commitHash;
        @Nullable
        CommitConsistency commitConsistency;
        @Nullable
        CommitMeta meta;

        Json() {
        }

        @JsonProperty(value="commitHash")
        public void setCommitHash(String commitHash) {
            this.commitHash = commitHash;
        }

        @JsonProperty(value="commitConsistency")
        public void setCommitConsistency(CommitConsistency commitConsistency) {
            this.commitConsistency = commitConsistency;
        }

        @JsonProperty(value="meta")
        public void setMeta(CommitMeta meta) {
            this.meta = meta;
        }

        @Override
        public String commitHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CommitConsistency commitConsistency() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CommitMeta meta() {
            throw new UnsupportedOperationException();
        }
    }
}

