/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Pattern;
import java.time.Duration;
import java.util.List;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.immutables.value.Value;
import org.projectnessie.model.ImmutableGarbageCollectorConfig;
import org.projectnessie.model.ImmutableReferenceCutoffPolicy;
import org.projectnessie.model.RepositoryConfig;
import org.projectnessie.model.Util;
import org.projectnessie.model.Validation;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Schema(type=SchemaType.OBJECT, title="Garbage collector config object")
@Tag(name="v2")
@JsonSerialize(as=ImmutableGarbageCollectorConfig.class)
@JsonDeserialize(as=ImmutableGarbageCollectorConfig.class)
@JsonTypeName(value="GARBAGE_COLLECTOR")
@Value.Immutable
public interface GarbageCollectorConfig
extends RepositoryConfig {
    public static ImmutableGarbageCollectorConfig.Builder builder() {
        return ImmutableGarbageCollectorConfig.builder();
    }

    @Schema(description="The default cutoff policy.\nPolicies can be one of: - number of commits as an integer value - a duration (see java.time.Duration) - an ISO instant - 'NONE', means everything's considered as live")
    @javax.annotation.Nullable
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @javax.validation.constraints.Pattern(regexp="NONE|^[1-9]\\d{0,10}|([-+]?)P(?:([-+]?[0-9]+)D)?(T(?:([-+]?[0-9]+)H)?(?:([-+]?[0-9]+)M)?(?:([-+]?[0-9]+)(?:[.,]([0-9]{0,9}))?S)?)?|^(?:[1-9]\\d{3}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1\\d|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[1-9]\\d(?:0[48]|[2468][048]|[13579][26])|(?:[2468][048]|[13579][26])00)-02-29)T(?:[01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(?:\\.\\d{1,9})?(?:Z|[+-][01]\\d:[0-5]\\d)$", message="Default cut-off-policy must be either the number of commits, a duration (as per java.time.Duration) or an ISO instant (like 2011-12-03T10:15:30Z) ")
    @Pattern(regexp="NONE|^[1-9]\\d{0,10}|([-+]?)P(?:([-+]?[0-9]+)D)?(T(?:([-+]?[0-9]+)H)?(?:([-+]?[0-9]+)M)?(?:([-+]?[0-9]+)(?:[.,]([0-9]{0,9}))?S)?)?|^(?:[1-9]\\d{3}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1\\d|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[1-9]\\d(?:0[48]|[2468][048]|[13579][26])|(?:[2468][048]|[13579][26])00)-02-29)T(?:[01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(?:\\.\\d{1,9})?(?:Z|[+-][01]\\d:[0-5]\\d)$", message="Default cut-off-policy must be either the number of commits, a duration (as per java.time.Duration) or an ISO instant (like 2011-12-03T10:15:30Z) ")
    public @javax.validation.constraints.Pattern(regexp="NONE|^[1-9]\\d{0,10}|([-+]?)P(?:([-+]?[0-9]+)D)?(T(?:([-+]?[0-9]+)H)?(?:([-+]?[0-9]+)M)?(?:([-+]?[0-9]+)(?:[.,]([0-9]{0,9}))?S)?)?|^(?:[1-9]\\d{3}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1\\d|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[1-9]\\d(?:0[48]|[2468][048]|[13579][26])|(?:[2468][048]|[13579][26])00)-02-29)T(?:[01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(?:\\.\\d{1,9})?(?:Z|[+-][01]\\d:[0-5]\\d)$", message="Default cut-off-policy must be either the number of commits, a duration (as per java.time.Duration) or an ISO instant (like 2011-12-03T10:15:30Z) ") @Pattern(regexp="NONE|^[1-9]\\d{0,10}|([-+]?)P(?:([-+]?[0-9]+)D)?(T(?:([-+]?[0-9]+)H)?(?:([-+]?[0-9]+)M)?(?:([-+]?[0-9]+)(?:[.,]([0-9]{0,9}))?S)?)?|^(?:[1-9]\\d{3}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1\\d|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[1-9]\\d(?:0[48]|[2468][048]|[13579][26])|(?:[2468][048]|[13579][26])00)-02-29)T(?:[01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(?:\\.\\d{1,9})?(?:Z|[+-][01]\\d:[0-5]\\d)$", message="Default cut-off-policy must be either the number of commits, a duration (as per java.time.Duration) or an ISO instant (like 2011-12-03T10:15:30Z) ") String getDefaultCutoffPolicy();

    @Value.Check
    default public void checkDefaultPolicy() {
        String defaultCutoffPolicy = this.getDefaultCutoffPolicy();
        if (defaultCutoffPolicy != null) {
            Validation.validateDefaultCutOffPolicy(defaultCutoffPolicy);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<ReferenceCutoffPolicy> getPerRefCutoffPolicies();

    @Schema(title="Grace period for files created concurrent to GC runs.", description="Files that have been created after 'gc-start-time - new-files-grace-period' are not being deleted.")
    @javax.annotation.Nullable
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=Util.DurationSerializer.class)
    @JsonDeserialize(using=Util.DurationDeserializer.class)
    public Duration getNewFilesGracePeriod();

    @Schema(title="The total number of expected live files for a single content.")
    @javax.annotation.Nullable
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getExpectedFileCountPerContent();

    @Override
    default public RepositoryConfig.Type getType() {
        return RepositoryConfig.Type.GARBAGE_COLLECTOR;
    }

    @Schema(type=SchemaType.OBJECT, title="References cutoff policy", description="Cutoff policies per reference names. Supplied as a ref-name-pattern=policy tuple. Reference name patterns are regular expressions.")
    @JsonSerialize(as=ImmutableReferenceCutoffPolicy.class)
    @JsonDeserialize(as=ImmutableReferenceCutoffPolicy.class)
    @Value.Immutable
    public static interface ReferenceCutoffPolicy {
        public static ReferenceCutoffPolicy referenceCutoffPolicy(String referenceNamePattern, String policy) {
            return ImmutableReferenceCutoffPolicy.of(referenceNamePattern, policy);
        }

        public static ImmutableReferenceCutoffPolicy.Builder builder() {
            return ImmutableReferenceCutoffPolicy.builder();
        }

        @Schema(description="Reference name patterns as a regular expressions.")
        @Value.Parameter(order=1)
        public String getReferenceNamePattern();

        @Schema(description="Policies can be one of: - number of commits as an integer value - a duration (see java.time.Duration) - an ISO instant - 'NONE', means everything's considered as live")
        @Value.Parameter(order=2)
        public String getPolicy();
    }
}

