/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v1.params;

import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.immutables.builder.Builder;
import org.projectnessie.api.v1.params.GetReferenceParamsBuilder;
import org.projectnessie.model.FetchOption;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class GetReferenceParams {
    @Parameter(description="name of ref to fetch", examples={@ExampleObject(ref="ref")})
    @PathParam(value="ref")
    @NotNull
    @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'")
    private @NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String refName;
    @Parameter(description="Specify how much information to be returned. Will fetch additional metadata for references if set to 'ALL'.\n\nA returned Branch instance will have the following information:\n\n- numCommitsAhead (number of commits ahead of the default branch)\n\n- numCommitsBehind (number of commits behind the default branch)\n\n- commitMetaOfHEAD (the commit metadata of the HEAD commit)\n\n- commonAncestorHash (the hash of the common ancestor in relation to the default branch).\n\n- numTotalCommits (the total number of commits in this reference).\n\nA returned Tag instance will only contain the 'commitMetaOfHEAD' and 'numTotalCommits' fields.\n\nNote that computing & fetching additional metadata might be computationally expensive on the server-side, so this flag should be used with care.")
    @QueryParam(value="fetch")
    @Nullable
    private FetchOption fetchOption;

    public GetReferenceParams() {
    }

    @Builder.Constructor
    GetReferenceParams(@NotNull String refName, @Nullable FetchOption fetchOption) {
        this.refName = refName;
        this.fetchOption = fetchOption;
    }

    @Nullable
    public FetchOption fetchOption() {
        return this.fetchOption;
    }

    public String getRefName() {
        return this.refName;
    }

    public static GetReferenceParamsBuilder builder() {
        return new GetReferenceParamsBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetReferenceParams)) {
            return false;
        }
        GetReferenceParams that = (GetReferenceParams)o;
        return this.fetchOption == that.fetchOption && Objects.equals(this.refName, that.refName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.refName, this.fetchOption});
    }

    public String toString() {
        return new StringJoiner(", ", GetReferenceParams.class.getSimpleName() + "[", "]").add("refName='" + this.refName + "'").add("fetchOption=" + (Object)((Object)this.fetchOption)).toString();
    }
}

