/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v2.params;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.api.v2.params.EntriesParams;
import org.projectnessie.model.ContentKey;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ParametersAreNonnullByDefault
@Generated(from="org.projectnessie.api.v2.params.EntriesParams", generator="Immutables")
@NotThreadSafe
public final class EntriesParamsBuilder {
    @Nullable
    private Integer maxRecords;
    @Nullable
    private String pageToken;
    @Nullable
    private ContentKey minKey;
    @Nullable
    private ContentKey maxKey;
    @Nullable
    private ContentKey prefixKey;
    private List<ContentKey> requestedKeys = null;
    @Nullable
    private String filter;
    @Nullable
    private Boolean withContent;

    public final EntriesParamsBuilder maxRecords(@jakarta.annotation.Nullable Integer maxRecords) {
        this.maxRecords = maxRecords;
        return this;
    }

    public final EntriesParamsBuilder pageToken(@jakarta.annotation.Nullable String pageToken) {
        this.pageToken = pageToken;
        return this;
    }

    public final EntriesParamsBuilder minKey(@jakarta.annotation.Nullable ContentKey minKey) {
        this.minKey = minKey;
        return this;
    }

    public final EntriesParamsBuilder maxKey(@jakarta.annotation.Nullable ContentKey maxKey) {
        this.maxKey = maxKey;
        return this;
    }

    public final EntriesParamsBuilder prefixKey(@jakarta.annotation.Nullable ContentKey prefixKey) {
        this.prefixKey = prefixKey;
        return this;
    }

    public final EntriesParamsBuilder addRequestedKeys(ContentKey element) {
        if (this.requestedKeys == null) {
            this.requestedKeys = new ArrayList<ContentKey>();
        }
        this.requestedKeys.add(Objects.requireNonNull(element, "requestedKeys element"));
        return this;
    }

    public final EntriesParamsBuilder addRequestedKeys(ContentKey ... elements) {
        if (this.requestedKeys == null) {
            this.requestedKeys = new ArrayList<ContentKey>();
        }
        for (ContentKey element : elements) {
            this.requestedKeys.add(Objects.requireNonNull(element, "requestedKeys element"));
        }
        return this;
    }

    public final EntriesParamsBuilder requestedKeys(@jakarta.annotation.Nullable Iterable<? extends ContentKey> elements) {
        if (elements == null) {
            this.requestedKeys = null;
            return this;
        }
        this.requestedKeys = new ArrayList<ContentKey>();
        return this.addAllRequestedKeys(elements);
    }

    public final EntriesParamsBuilder addAllRequestedKeys(Iterable<? extends ContentKey> elements) {
        Objects.requireNonNull(elements, "requestedKeys element");
        if (this.requestedKeys == null) {
            this.requestedKeys = new ArrayList<ContentKey>();
        }
        for (ContentKey contentKey : elements) {
            this.requestedKeys.add(Objects.requireNonNull(contentKey, "requestedKeys element"));
        }
        return this;
    }

    public final EntriesParamsBuilder filter(@jakarta.annotation.Nullable String filter) {
        this.filter = filter;
        return this;
    }

    public final EntriesParamsBuilder withContent(@jakarta.annotation.Nullable Boolean withContent) {
        this.withContent = withContent;
        return this;
    }

    public EntriesParams build() {
        return new EntriesParams(this.maxRecords, this.pageToken, this.minKey, this.maxKey, this.prefixKey, this.requestedKeys == null ? null : EntriesParamsBuilder.createUnmodifiableList(true, this.requestedKeys), this.filter, this.withContent);
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }
}

