/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model.metadata;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Map;
import javax.annotation.Nullable;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.model.ContentMetadata;
import org.projectnessie.model.metadata.GenericContentMetadataSerialization;
import org.projectnessie.model.metadata.ImmutableGenericContentMetadata;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@JsonSerialize(using=GenericContentMetadataSerialization.GenericContentMetadataSerializer.class)
@JsonDeserialize(using=GenericContentMetadataSerialization.GenericContentMetadataDeserializer.class)
@Value.Immutable
public interface GenericContentMetadata
extends ContentMetadata {
    @Override
    @Value.Parameter(order=1)
    public String getVariant();

    @Nullable
    @Schema(type=SchemaType.OBJECT)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonUnwrapped
    @Value.Parameter(order=2)
    public Map<String, Object> getAttributes();

    public static GenericContentMetadata genericContentMetadata(String variant, Map<String, Object> attributes) {
        return ImmutableGenericContentMetadata.of(variant, attributes);
    }
}

