/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.error;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.error.ImmutableNessieError;
import org.projectnessie.error.NessieErrorDetails;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@JsonSerialize(as=ImmutableNessieError.class)
@JsonDeserialize(as=ImmutableNessieError.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@Value.Immutable
public interface NessieError {
    public int getStatus();

    public String getReason();

    @Value.Default
    default public String getMessage() {
        return this.getReason();
    }

    @JsonDeserialize(using=ErrorCode.Deserializer.class)
    @Value.Default
    default public ErrorCode getErrorCode() {
        return ErrorCode.UNKNOWN;
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public NessieErrorDetails getErrorDetails();

    default public <T extends NessieErrorDetails> T getErrorDetailsAsOrNull(Class<T> type) {
        NessieErrorDetails details = this.getErrorDetails();
        return (T)(details != null && type.isAssignableFrom(details.getClass()) ? (NessieErrorDetails)type.cast(details) : null);
    }

    @Nullable
    public String getServerStackTrace();

    @JsonIgnore
    @Nullable
    @Deprecated
    @Value.Auxiliary
    public Exception getClientProcessingException();

    @JsonIgnore
    @Nullable
    @Value.Auxiliary
    public String getClientProcessingError();

    @JsonIgnore
    default public String getFullMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getReason()).append(" (HTTP/").append(this.getStatus()).append(')');
        sb.append(": ");
        String serverMessage = this.getMessage();
        if (serverMessage == null) {
            serverMessage = "[no error message found in HTTP response]";
        }
        sb.append(serverMessage);
        if (this.getServerStackTrace() != null) {
            sb.append("\n").append(this.getServerStackTrace());
        }
        if (this.getClientProcessingError() != null) {
            sb.append("\nAdditionally, the client-side error below was caught while decoding the HTTP response: ").append(this.getClientProcessingError());
        } else if (this.getClientProcessingException() != null) {
            sb.append("\nAdditionally, the client-side exception below was caught while decoding the HTTP response: ").append(this.getClientProcessingException());
        }
        return sb.toString();
    }
}

