/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import java.util.Map;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.model.Content;
import org.projectnessie.model.types.ImmutableGenericContent;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@JsonSerialize(using=ContentUnknownTypeSerializer.class)
@JsonDeserialize(using=ContentUnknownTypeDeserializer.class)
@Value.Immutable
public abstract class GenericContent
extends Content {
    @Override
    @Value.Parameter(order=1)
    public abstract Content.Type getType();

    @Override
    @Value.Parameter(order=2)
    public abstract String getId();

    @Schema(type=SchemaType.OBJECT)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonUnwrapped
    @Value.Parameter(order=3)
    public abstract Map<String, Object> getAttributes();

    public static GenericContent contentUnknownType(final String type, String id, Map<String, Object> all) {
        return ImmutableGenericContent.of(new Content.Type(){

            @Override
            public String name() {
                return type;
            }

            @Override
            public Class<? extends Content> type() {
                return GenericContent.class;
            }
        }, id, all);
    }

    static final class ContentUnknownTypeDeserializer
    extends JsonDeserializer<GenericContent> {
        ContentUnknownTypeDeserializer() {
        }

        public GenericContent deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Map all = (Map)p.readValueAs(Map.class);
            Object type = all.remove("type");
            Object id = all.remove("id");
            if (type == null) {
                type = "UNKNOWN_CONTENT_TYPE";
            }
            return GenericContent.contentUnknownType(type.toString(), id != null ? id.toString() : null, all);
        }
    }

    static final class ContentUnknownTypeSerializer
    extends JsonSerializer<GenericContent> {
        ContentUnknownTypeSerializer() {
        }

        public void serializeWithType(GenericContent value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("type", value.getType().name());
            String id = value.getId();
            if (id != null) {
                gen.writeStringField("id", id);
            }
            for (Map.Entry<String, Object> entry : value.getAttributes().entrySet()) {
                gen.writeFieldName(entry.getKey());
                gen.writeObject(entry.getValue());
            }
            gen.writeEndObject();
        }

        public void serialize(GenericContent value, JsonGenerator gen, SerializerProvider serializers) {
            throw new UnsupportedOperationException();
        }
    }
}

