/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v2.params;

import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.immutables.builder.Builder;
import org.projectnessie.api.v2.params.ReferenceHistoryParamsBuilder;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ReferenceHistoryParams {
    @Parameter(description="Specifies a reference to a particular commit history branch or tag.\n\nThis reference can be specification in these forms:\n- \\- (literal minus character) - identifies the default branch.\n- name - Identifies the named branch or tag.\n", examples={@ExampleObject(ref="ref"), @ExampleObject(ref="refDefault")})
    @PathParam(value="ref")
    @NotNull
    @Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'")
    private @NotNull @Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String ref;
    @Parameter(description="Optional parameter, specifies the number of commits to scan from the reference's current HEAD, limited to the given amount of commits. Default is to not scan the commit log. The server may impose a hard limit on the amount of commits from the commit log.")
    @QueryParam(value="scan-commits")
    @Nullable
    private Integer headCommitsToScan;

    public ReferenceHistoryParams() {
    }

    @Builder.Constructor
    ReferenceHistoryParams(@NotNull String ref, @Nullable Integer headCommitsToScan) {
        this.ref = ref;
        this.headCommitsToScan = headCommitsToScan;
    }

    @Nullable
    public Integer headCommitsToScan() {
        return this.headCommitsToScan;
    }

    public String getRef() {
        return this.ref;
    }

    public static ReferenceHistoryParamsBuilder builder() {
        return new ReferenceHistoryParamsBuilder();
    }
}

