/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model.metadata;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import java.util.Map;
import org.projectnessie.model.metadata.GenericContentMetadata;

public class GenericContentMetadataSerialization {

    static final class GenericContentMetadataDeserializer
    extends JsonDeserializer<GenericContentMetadata> {
        GenericContentMetadataDeserializer() {
        }

        public GenericContentMetadata deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Map all = (Map)p.readValueAs(Map.class);
            Object variant = all.remove("variant");
            if (variant == null) {
                variant = "UNKNOWN_VARIANT";
            }
            return GenericContentMetadata.genericContentMetadata(variant.toString(), all);
        }
    }

    static final class GenericContentMetadataSerializer
    extends JsonSerializer<GenericContentMetadata> {
        GenericContentMetadataSerializer() {
        }

        public void serializeWithType(GenericContentMetadata value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("variant", value.getVariant());
            for (Map.Entry<String, Object> entry : value.getAttributes().entrySet()) {
                gen.writeFieldName(entry.getKey());
                gen.writeObject(entry.getValue());
            }
            gen.writeEndObject();
        }

        public void serialize(GenericContentMetadata value, JsonGenerator gen, SerializerProvider serializers) {
            throw new UnsupportedOperationException();
        }
    }
}

