/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotBlank;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.model.Content;
import org.projectnessie.model.IcebergContent;
import org.projectnessie.model.ImmutableIcebergTable;
import org.projectnessie.model.ser.Views;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Schema(type=SchemaType.OBJECT, title="Iceberg table state", description="Represents the state of an Iceberg table in Nessie. An Iceberg table is globally identified via its unique 'Content.id'.\n\nA Nessie commit-operation, performed via 'TreeApi.commitMultipleOperations',for Iceberg consists of a 'Operation.Put' with an 'IcebergTable' as in the 'content' field and the previous value of 'IcebergTable' in the 'expectedContent' field.")
@JsonSerialize(as=ImmutableIcebergTable.class)
@JsonDeserialize(as=ImmutableIcebergTable.class)
@JsonTypeName(value="ICEBERG_TABLE")
@Value.Immutable
public abstract class IcebergTable
extends IcebergContent {
    @Override
    @NotNull
    @jakarta.validation.constraints.NotNull
    @javax.validation.constraints.NotBlank
    @NotBlank
    public abstract String getMetadataLocation();

    public abstract long getSnapshotId();

    @Override
    @JsonIgnore
    @Value.NonAttribute
    public long getVersionId() {
        return this.getSnapshotId();
    }

    public abstract int getSchemaId();

    public abstract int getSpecId();

    public abstract int getSortOrderId();

    @Override
    public Content.Type getType() {
        return Content.Type.ICEBERG_TABLE;
    }

    @Deprecated
    @javax.annotation.Nullable
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonView(value={Views.V1.class})
    public abstract Map<String, Object> getMetadata();

    @Override
    public abstract IcebergTable withId(String var1);

    public static ImmutableIcebergTable.Builder builder() {
        return ImmutableIcebergTable.builder();
    }

    public static IcebergTable of(String metadataLocation, long snapshotId, int schemaId, int specId, int sortOrderId) {
        return IcebergTable.builder().metadataLocation(metadataLocation).snapshotId(snapshotId).schemaId(schemaId).specId(specId).sortOrderId(sortOrderId).build();
    }

    public static IcebergTable of(String metadataLocation, long snapshotId, int schemaId, int specId, int sortOrderId, String contentId) {
        return IcebergTable.builder().metadataLocation(metadataLocation).snapshotId(snapshotId).schemaId(schemaId).specId(specId).sortOrderId(sortOrderId).id(contentId).build();
    }
}

