/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v1.params;

import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.immutables.builder.Builder;
import org.projectnessie.api.v1.params.GetReferenceParamsBuilder;
import org.projectnessie.model.FetchOption;

public class GetReferenceParams {
    @Parameter(description="name of ref to fetch", examples={@ExampleObject(ref="ref")})
    @PathParam(value="ref")
    @jakarta.ws.rs.PathParam(value="ref")
    @javax.validation.constraints.NotNull
    @NotNull
    @javax.validation.constraints.Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'")
    @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'")
    private @javax.validation.constraints.NotNull @NotNull @javax.validation.constraints.Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String refName;
    @Parameter(description="Specify how much information to be returned. Will fetch additional metadata for references if set to 'ALL'.\n\nA returned Branch instance will have the following information:\n\n- numCommitsAhead (number of commits ahead of the default branch)\n\n- numCommitsBehind (number of commits behind the default branch)\n\n- commitMetaOfHEAD (the commit metadata of the HEAD commit)\n\n- commonAncestorHash (the hash of the common ancestor in relation to the default branch).\n\n- numTotalCommits (the total number of commits in this reference).\n\nA returned Tag instance will only contain the 'commitMetaOfHEAD' and 'numTotalCommits' fields.\n\nNote that computing & fetching additional metadata might be computationally expensive on the server-side, so this flag should be used with care.")
    @QueryParam(value="fetch")
    @jakarta.ws.rs.QueryParam(value="fetch")
    @Nullable
    @jakarta.annotation.Nullable
    private FetchOption fetchOption;

    public GetReferenceParams() {
    }

    @Builder.Constructor
    GetReferenceParams(@javax.validation.constraints.NotNull @NotNull String refName, @Nullable @jakarta.annotation.Nullable FetchOption fetchOption) {
        this.refName = refName;
        this.fetchOption = fetchOption;
    }

    @Nullable
    @jakarta.annotation.Nullable
    public FetchOption fetchOption() {
        return this.fetchOption;
    }

    public String getRefName() {
        return this.refName;
    }

    public static GetReferenceParamsBuilder builder() {
        return new GetReferenceParamsBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetReferenceParams)) {
            return false;
        }
        GetReferenceParams that = (GetReferenceParams)o;
        return this.fetchOption == that.fetchOption && Objects.equals(this.refName, that.refName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.refName, this.fetchOption});
    }

    public String toString() {
        return new StringJoiner(", ", GetReferenceParams.class.getSimpleName() + "[", "]").add("refName='" + this.refName + "'").add("fetchOption=" + String.valueOf((Object)this.fetchOption)).toString();
    }
}

