/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.junit.engine;

import java.util.Optional;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.launcher.PostDiscoveryFilter;

public class MultiEnvTestFilter
implements PostDiscoveryFilter {
    static Optional<Class<?>> classFor(TestDescriptor object) {
        TestDescriptor d = object;
        while (d != null) {
            if (d instanceof ClassBasedTestDescriptor) {
                return Optional.of(((ClassBasedTestDescriptor)d).getTestClass());
            }
            d = d.getParent().orElse(null);
        }
        return Optional.empty();
    }

    private FilterResult filter(UniqueId id) {
        if (id.getEngineId().map("junit-jupiter"::equals).orElse(false).booleanValue()) {
            return FilterResult.excluded((String)("Excluding multi-env test from Jupiter Engine: " + String.valueOf(id)));
        }
        return FilterResult.included(null);
    }

    public FilterResult apply(TestDescriptor test) {
        return MultiEnvTestFilter.classFor(test).map(testClass -> this.filter(test.getUniqueId())).orElseGet(() -> FilterResult.included(null));
    }
}

