/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.junit.engine;

import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.engine.config.CachingJupiterConfiguration;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.JupiterEngineDescriptor;
import org.junit.jupiter.engine.discovery.DiscoverySelectorResolver;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.UniqueId;
import org.projectnessie.junit.engine.JUnitCompat;
import org.projectnessie.junit.engine.MultiEnvExtensionRegistry;
import org.projectnessie.junit.engine.MultiEnvJupiterConfiguration;
import org.projectnessie.junit.engine.MultiEnvTestDescriptor;
import org.projectnessie.junit.engine.ThreadPerTestClassExecutionTestEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiEnvTestEngine
implements TestEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiEnvTestEngine.class);
    private static final boolean FAIL_ON_MISSING_ENVIRONMENTS = !Boolean.getBoolean("org.projectnessie.junit.engine.ignore-empty-environments");
    public static final String ENGINE_ID = "nessie-multi-env";
    private static MultiEnvExtensionRegistry registry;
    private final ThreadPerTestClassExecutionTestEngine delegate = new ThreadPerTestClassExecutionTestEngine();

    static MultiEnvExtensionRegistry registry() {
        return registry;
    }

    public String getId() {
        return ENGINE_ID;
    }

    public void execute(ExecutionRequest request) {
        this.delegate.execute(request);
    }

    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        try {
            if (registry == null) {
                registry = new MultiEnvExtensionRegistry(discoveryRequest);
            }
            TestDescriptor preliminaryResult = this.delegate.discover(discoveryRequest, uniqueId);
            preliminaryResult.accept(registry::registerExtensions);
            ConfigurationParameters configurationParameters = discoveryRequest.getConfigurationParameters();
            JupiterEngineDescriptor multiEnvRootDescriptor = new JupiterEngineDescriptor(uniqueId, JUnitCompat.newDefaultJupiterConfiguration(discoveryRequest));
            ArrayList extensions = new ArrayList();
            AtomicBoolean multiEnvDiscovered = new AtomicBoolean();
            registry.stream().forEach(ext -> {
                extensions.add(ext.getClass().getSimpleName());
                for (String envId : ext.allEnvironmentIds(configurationParameters)) {
                    multiEnvDiscovered.set(true);
                    UniqueId segment = uniqueId.append(ext.segmentType(), envId);
                    MultiEnvTestDescriptor envRoot = new MultiEnvTestDescriptor(segment, envId);
                    multiEnvRootDescriptor.addChild((TestDescriptor)envRoot);
                    CachingJupiterConfiguration envRootConfiguration = new CachingJupiterConfiguration((JupiterConfiguration)new MultiEnvJupiterConfiguration(discoveryRequest, envId));
                    JupiterEngineDescriptor discoverResult = new JupiterEngineDescriptor(segment, (JupiterConfiguration)envRootConfiguration);
                    new DiscoverySelectorResolver().resolveSelectors(discoveryRequest, discoverResult);
                    ArrayList children = new ArrayList(discoverResult.getChildren());
                    for (TestDescriptor child : children) {
                        discoverResult.removeChild(child);
                        ClassBasedTestDescriptor classBased = (ClassBasedTestDescriptor)child;
                        boolean multi = MultiEnvExtensionRegistry.isMultiEnvClass((TestDescriptor)classBased);
                        if (!multi) continue;
                        envRoot.addChild(child);
                    }
                }
            });
            MultiEnvTestEngine.registry().probablyNotMultiEnv().forEach(td -> {
                CachingJupiterConfiguration jupiterConfiguration = new CachingJupiterConfiguration(JUnitCompat.newDefaultJupiterConfiguration(discoveryRequest));
                JupiterEngineDescriptor discoverResult = new JupiterEngineDescriptor(uniqueId, (JupiterConfiguration)jupiterConfiguration);
                new DiscoverySelectorResolver().resolveSelectors(discoveryRequest, discoverResult);
                ArrayList children = new ArrayList(discoverResult.getChildren());
                for (TestDescriptor child : children) {
                    ClassBasedTestDescriptor classBased = (ClassBasedTestDescriptor)child;
                    boolean multi = MultiEnvExtensionRegistry.isMultiEnvClass((TestDescriptor)classBased);
                    if (multi) continue;
                    discoverResult.removeChild(child);
                    multiEnvRootDescriptor.addChild(child);
                }
            });
            if (!extensions.isEmpty() && !multiEnvDiscovered.get() && FAIL_ON_MISSING_ENVIRONMENTS) {
                throw new IllegalStateException(String.format("%s was enabled, but test extensions did not discover any environment IDs: %s", this.getClass().getSimpleName(), extensions));
            }
            return multiEnvRootDescriptor;
        }
        catch (Exception e) {
            LOGGER.error("Failed to discover tests", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Optional<String> getGroupId() {
        return Optional.of("org.projectnessie.nessie");
    }

    public Optional<String> getArtifactId() {
        return Optional.of("nessie-compatibility-tools");
    }
}

