/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.junit.engine;

import java.lang.reflect.Constructor;
import org.junit.jupiter.engine.config.DefaultJupiterConfiguration;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.reporting.OutputDirectoryProvider;

final class JUnitCompat {
    static Class<?> CLASS_OUTPUT_DIRECTORY_PROVIDER;

    private JUnitCompat() {
    }

    static JupiterConfiguration newDefaultJupiterConfiguration(EngineDiscoveryRequest request) {
        return JUnitCompat.newDefaultJupiterConfiguration(request.getConfigurationParameters(), request);
    }

    static JupiterConfiguration newDefaultJupiterConfiguration(ConfigurationParameters configurationParameters, EngineDiscoveryRequest request) {
        try {
            if (CLASS_OUTPUT_DIRECTORY_PROVIDER != null) {
                return JUnitCompat.newDefaultJupiterConfiguration512(configurationParameters, request);
            }
            Constructor ctorBefore512 = DefaultJupiterConfiguration.class.getDeclaredConstructor(ConfigurationParameters.class);
            return (JupiterConfiguration)ctorBefore512.newInstance(configurationParameters);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static JupiterConfiguration newDefaultJupiterConfiguration512(ConfigurationParameters configurationParameters, EngineDiscoveryRequest request) throws Exception {
        Constructor ctorSince512 = DefaultJupiterConfiguration.class.getDeclaredConstructor(ConfigurationParameters.class, OutputDirectoryProvider.class);
        return (JupiterConfiguration)ctorSince512.newInstance(configurationParameters, request.getOutputDirectoryProvider());
    }

    static {
        try {
            CLASS_OUTPUT_DIRECTORY_PROVIDER = Class.forName("org.junit.platform.engine.reporting.OutputDirectoryProvider");
        }
        catch (ClassNotFoundException e) {
            CLASS_OUTPUT_DIRECTORY_PROVIDER = null;
        }
    }
}

