/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.junit.engine;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.jupiter.engine.extension.MutableExtensionRegistry;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.TestDescriptor;
import org.projectnessie.junit.engine.EmptyConfigurationParameters;
import org.projectnessie.junit.engine.JUnitCompat;
import org.projectnessie.junit.engine.MultiEnvTestExtension;

public class MultiEnvExtensionRegistry {
    private final MutableExtensionRegistry registry;
    private final Set<TestDescriptor> probablyNotMultiEnv = new LinkedHashSet<TestDescriptor>();

    public MultiEnvExtensionRegistry(EngineDiscoveryRequest discoveryRequest) {
        this.registry = MutableExtensionRegistry.createRegistryWithDefaultExtensions((JupiterConfiguration)JUnitCompat.newDefaultJupiterConfiguration(new EmptyConfigurationParameters(), discoveryRequest));
    }

    public void registerExtensions(TestDescriptor descriptor) {
        AtomicBoolean multiEnv = new AtomicBoolean(false);
        MultiEnvExtensionRegistry.findMultiEnvExtensions(descriptor).peek(x -> multiEnv.set(true)).forEach(arg_0 -> ((MutableExtensionRegistry)this.registry).registerExtension(arg_0));
        if (!multiEnv.get()) {
            this.probablyNotMultiEnv.add(descriptor);
        }
    }

    public static boolean isMultiEnvClass(TestDescriptor descriptor) {
        return MultiEnvExtensionRegistry.findMultiEnvExtensions(descriptor).findFirst().isPresent();
    }

    private static Stream<Class<? extends Extension>> findMultiEnvExtensions(TestDescriptor descriptor) {
        if (descriptor instanceof ClassBasedTestDescriptor) {
            ClassBasedTestDescriptor classBased = (ClassBasedTestDescriptor)descriptor;
            Class testClass = classBased.getTestClass();
            return AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)testClass, ExtendWith.class).stream().flatMap(e -> Arrays.stream(e.value())).filter(MultiEnvTestExtension.class::isAssignableFrom);
        }
        return Stream.empty();
    }

    public Stream<TestDescriptor> probablyNotMultiEnv() {
        return this.probablyNotMultiEnv.stream();
    }

    public Stream<MultiEnvTestExtension> stream() {
        return this.registry.stream(MultiEnvTestExtension.class);
    }

    public Stream<? extends MultiEnvTestExtension> stream(Class<?> testClass) {
        HashSet annotations = new HashSet();
        for (Class<?> cl = testClass; cl != null; cl = cl.getDeclaringClass()) {
            annotations.addAll(AnnotationUtils.findRepeatableAnnotations(cl, ExtendWith.class));
        }
        Stream r = annotations.stream().flatMap(e -> Arrays.stream(e.value())).filter(MultiEnvTestExtension.class::isAssignableFrom).flatMap(arg_0 -> ((MutableExtensionRegistry)this.registry).stream(arg_0));
        return r;
    }
}

