/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.junit.engine;

import java.lang.reflect.Constructor;
import java.util.Optional;
import org.junit.jupiter.engine.config.CachingJupiterConfiguration;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.JupiterEngineDescriptor;
import org.junit.jupiter.engine.descriptor.LauncherStoreFacade;
import org.junit.jupiter.engine.discovery.DiscoverySelectorResolver;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.support.JupiterThrowableCollectorFactory;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestEngine;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestExecutorService;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;
import org.projectnessie.junit.engine.JUnitCompat;
import org.projectnessie.junit.engine.ThreadPerTestClassExecutionExecutorService;

public class ThreadPerTestClassExecutionTestEngine
extends HierarchicalTestEngine<JupiterEngineExecutionContext> {
    public String getId() {
        return "junit-jupiter";
    }

    public Optional<String> getGroupId() {
        return Optional.of("org.junit.jupiter");
    }

    public Optional<String> getArtifactId() {
        return Optional.of("junit-jupiter-engine");
    }

    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        CachingJupiterConfiguration configuration = new CachingJupiterConfiguration(JUnitCompat.newDefaultJupiterConfiguration(discoveryRequest));
        JupiterEngineDescriptor engineDescriptor = new JupiterEngineDescriptor(uniqueId, (JupiterConfiguration)configuration);
        new DiscoverySelectorResolver().resolveSelectors(discoveryRequest, engineDescriptor);
        return engineDescriptor;
    }

    protected HierarchicalTestExecutorService createExecutorService(ExecutionRequest request) {
        return new ThreadPerTestClassExecutionExecutorService();
    }

    protected JupiterEngineExecutionContext createExecutionContext(ExecutionRequest request) {
        try {
            Class.forName("org.junit.jupiter.engine.descriptor.LauncherStoreFacade");
            return this.createExecutionContext513(request);
        }
        catch (ClassNotFoundException e) {
            return this.createExecutionContext512(request);
        }
    }

    private JupiterEngineExecutionContext createExecutionContext512(ExecutionRequest request) {
        try {
            Constructor ctor = JupiterEngineExecutionContext.class.getDeclaredConstructor(EngineExecutionListener.class, JupiterConfiguration.class);
            return (JupiterEngineExecutionContext)JupiterEngineExecutionContext.class.cast(ctor.newInstance(request.getEngineExecutionListener(), this.getJupiterConfiguration(request)));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private JupiterEngineExecutionContext createExecutionContext513(ExecutionRequest request) {
        return new JupiterEngineExecutionContext(request.getEngineExecutionListener(), this.getJupiterConfiguration(request), new LauncherStoreFacade(request.getStore()));
    }

    protected ThrowableCollector.Factory createThrowableCollectorFactory(ExecutionRequest request) {
        return JupiterThrowableCollectorFactory::createThrowableCollector;
    }

    private JupiterConfiguration getJupiterConfiguration(ExecutionRequest request) {
        JupiterEngineDescriptor engineDescriptor = (JupiterEngineDescriptor)request.getRootTestDescriptor();
        return engineDescriptor.getConfiguration();
    }
}

