/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.junit.engine;

import java.util.Optional;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.projectnessie.junit.engine.MultiEnvExtensionRegistry;
import org.projectnessie.junit.engine.MultiEnvTestEngine;

public class MultiEnvTestFilter
implements PostDiscoveryFilter {
    private Optional<Class<?>> classFor(TestDescriptor object) {
        TestDescriptor d = object;
        while (d != null) {
            if (d instanceof ClassBasedTestDescriptor) {
                return Optional.of(((ClassBasedTestDescriptor)d).getTestClass());
            }
            d = d.getParent().orElse(null);
        }
        return Optional.empty();
    }

    private FilterResult filter(Class<?> testClass, UniqueId id) {
        MultiEnvExtensionRegistry registry = MultiEnvTestEngine.registry();
        if (id.getEngineId().map("junit-jupiter"::equals).orElse(false).booleanValue()) {
            if (registry.stream(testClass).findAny().isPresent()) {
                return FilterResult.excluded((String)("Excluding multi-env test from Jupiter Engine: " + String.valueOf(id)));
            }
            return FilterResult.included(null);
        }
        boolean matched = registry.stream(testClass).anyMatch(ext -> id.getSegments().stream().anyMatch(s -> ext.segmentType().equals(s.getType())));
        if (matched) {
            return FilterResult.included(null);
        }
        return FilterResult.excluded((String)("Excluding unmatched multi-env test: " + String.valueOf(id)));
    }

    public FilterResult apply(TestDescriptor test) {
        return this.classFor(test).map(testClass -> this.filter((Class<?>)testClass, test.getUniqueId())).orElseGet(() -> FilterResult.included(null));
    }
}

