/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.junit.engine;

import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestExecutorService;

public class ThreadPerTestClassExecutionExecutorService
implements HierarchicalTestExecutorService {
    private static final Class<?> CLASS_NODE_TEST_TASK;
    private static final Field FIELD_TEST_DESCRIPTOR;

    protected TestDescriptor getTestDescriptor(HierarchicalTestExecutorService.TestTask testTask) {
        if (!CLASS_NODE_TEST_TASK.isAssignableFrom(testTask.getClass())) {
            throw new IllegalArgumentException(testTask.getClass().getName() + " is not of type " + CLASS_NODE_TEST_TASK.getName());
        }
        try {
            return (TestDescriptor)FIELD_TEST_DESCRIPTOR.get(testTask);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public Future<Void> submit(HierarchicalTestExecutorService.TestTask testTask) {
        this.executeTask(testTask);
        return CompletableFuture.completedFuture(null);
    }

    public void invokeAll(List<? extends HierarchicalTestExecutorService.TestTask> tasks) {
        tasks.forEach(this::executeTask);
    }

    protected void executeTask(HierarchicalTestExecutorService.TestTask testTask) {
        TestDescriptor testDescriptor = this.getTestDescriptor(testTask);
        UniqueId.Segment lastSegment = testDescriptor.getUniqueId().getLastSegment();
        String type = lastSegment.getType();
        if ("class".equals(type)) {
            AtomicReference failure = new AtomicReference();
            Thread threadPerClass = new Thread(() -> {
                try {
                    testTask.execute();
                }
                catch (Exception e) {
                    failure.set(e);
                }
            }, "TEST THREAD FOR " + lastSegment.getValue());
            threadPerClass.setDaemon(true);
            threadPerClass.start();
            try {
                threadPerClass.join();
            }
            catch (InterruptedException e) {
                threadPerClass.interrupt();
            }
            Exception ex = (Exception)failure.get();
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            if (ex != null) {
                throw new RuntimeException(ex);
            }
        } else {
            testTask.execute();
        }
    }

    public void close() {
    }

    static {
        try {
            CLASS_NODE_TEST_TASK = Class.forName("org.junit.platform.engine.support.hierarchical.NodeTestTask");
            FIELD_TEST_DESCRIPTOR = CLASS_NODE_TEST_TASK.getDeclaredField("testDescriptor");
            FIELD_TEST_DESCRIPTOR.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("ThreadPerExecutionExecutorService is probably not compatible with the current JUnit version", e);
        }
    }
}

