/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest.exceptions;

import jakarta.inject.Inject;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import java.util.function.Consumer;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.error.NessieError;
import org.projectnessie.services.config.ExceptionConfig;
import org.projectnessie.services.rest.common.RestCommon;

public abstract class BaseExceptionMapper<T extends Throwable>
implements ExceptionMapper<T> {
    @Inject
    ExceptionConfig config;
    @Context
    HttpHeaders headers;

    protected Response buildBadRequestResponse(Exception e) {
        return this.buildExceptionResponse(ErrorCode.BAD_REQUEST, e.getMessage(), e);
    }

    protected Response buildExceptionResponse(ErrorCode errorCode, String message, Exception e) {
        return this.buildExceptionResponse(errorCode, message, e, this.config.sendStacktraceToClient(), h -> {});
    }

    protected Response buildExceptionResponse(ErrorCode errorCode, String message, Exception e, boolean includeExceptionStackTrace, Consumer<Response.ResponseBuilder> responseHandler) {
        Response.Status status = Response.Status.fromStatusCode((int)errorCode.httpStatus());
        if (status == null) {
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        NessieError error = RestCommon.buildNessieError(message, status.getStatusCode(), status.getReasonPhrase(), errorCode, e, includeExceptionStackTrace, arg_0 -> ((HttpHeaders)this.headers).getHeaderString(arg_0));
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)status).entity((Object)error).type(MediaType.APPLICATION_JSON_TYPE);
        responseHandler.accept(responseBuilder);
        return responseBuilder.build();
    }
}

