/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest.exceptions;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.validation.ValidationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.services.rest.exceptions.BaseExceptionMapper;

@Provider
@ApplicationScoped
public class ValidationExceptionMapper
extends BaseExceptionMapper<ValidationException> {
    public Response toResponse(ValidationException exception) {
        return this.buildExceptionResponse(ErrorCode.UNKNOWN, this.unwrapException((Throwable)exception), (Exception)exception);
    }

    protected String unwrapException(Throwable t) {
        StringBuilder sb = new StringBuilder();
        this.doUnwrapException(sb, t);
        return sb.toString();
    }

    private void doUnwrapException(StringBuilder sb, Throwable t) {
        if (t == null) {
            return;
        }
        sb.append(t);
        if (t.getCause() != null && t != t.getCause()) {
            sb.append('[');
            this.doUnwrapException(sb, t.getCause());
            sb.append(']');
        }
    }
}

