/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest.common;

import com.google.common.base.Throwables;
import jakarta.ws.rs.core.HttpHeaders;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.error.ErrorCodeAware;
import org.projectnessie.error.ImmutableNessieError;
import org.projectnessie.error.NessieError;
import org.projectnessie.error.NessieErrorDetails;
import org.projectnessie.model.CommitMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RestCommon {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestCommon.class);

    private RestCommon() {
    }

    public static NessieError buildNessieError(String message, int statusCode, String statusReason, ErrorCode errorCode, Exception e, boolean includeExceptionStackTrace, Function<String, String> requestHeader) {
        NessieErrorDetails errorDetails;
        if (message == null) {
            message = "";
        }
        String stack = includeExceptionStackTrace ? Throwables.getStackTraceAsString((Throwable)e) : null;
        LOGGER.debug("Failure on server, propagated to client. Status: {} {}, Message: {}.", new Object[]{statusCode, statusReason, message, e});
        NessieErrorDetails nessieErrorDetails = errorDetails = e instanceof ErrorCodeAware ? ((ErrorCodeAware)e).getErrorDetails() : null;
        if (errorDetails != null && !RestCommon.isNessieClientSpec2(requestHeader)) {
            errorDetails = null;
        }
        return ImmutableNessieError.builder().message(message).status(statusCode).errorCode(errorCode).reason(statusReason).serverStackTrace(stack).errorDetails(errorDetails).build();
    }

    private static boolean isNessieClientSpec2(Function<String, String> requestHeader) {
        String clientSpec = requestHeader.apply("Nessie-Client-Spec");
        if (clientSpec == null) {
            return false;
        }
        try {
            int i = clientSpec.indexOf(46);
            if (i != -1) {
                clientSpec = clientSpec.substring(0, i);
            }
            return Integer.parseInt(clientSpec) >= 2;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static CommitMeta.Builder updateCommitMeta(CommitMeta.Builder commitMeta, HttpHeaders httpHeaders) {
        httpHeaders.getRequestHeaders().forEach((k, v) -> {
            if (!v.isEmpty()) {
                String lower;
                switch (lower = k.toLowerCase(Locale.ROOT)) {
                    case "nessie-commit-message": {
                        v.stream().map(String::trim).filter(s -> !s.isEmpty()).findFirst().ifPresent(arg_0 -> ((CommitMeta.Builder)commitMeta).message(arg_0));
                        break;
                    }
                    case "nessie-commit-authors": {
                        v.stream().flatMap(s -> Arrays.stream(s.split(","))).map(String::trim).filter(s -> !s.isEmpty()).forEach(arg_0 -> ((CommitMeta.Builder)commitMeta).addAllAuthors(arg_0));
                        break;
                    }
                    case "nessie-commit-signedoffby": {
                        v.stream().flatMap(s -> Arrays.stream(s.split(","))).map(String::trim).filter(s -> !s.isEmpty()).forEach(arg_0 -> ((CommitMeta.Builder)commitMeta).addAllSignedOffBy(arg_0));
                        break;
                    }
                    default: {
                        if (!lower.startsWith("nessie-commit-property-")) break;
                        String prop = lower.substring("nessie-commit-property-".length()).trim();
                        commitMeta.putAllProperties(prop, v.stream().map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList()));
                    }
                }
            }
        });
        return commitMeta;
    }
}

