/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest.exceptions;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.Throwables;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.util.stream.Collectors;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.services.rest.exceptions.BaseExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@ApplicationScoped
public class NessieExceptionMapper
extends BaseExceptionMapper<Exception> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NessieExceptionMapper.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Response toResponse(Exception exception) {
        String message;
        ErrorCode errorCode;
        if (exception instanceof BaseNessieClientServerException) {
            BaseNessieClientServerException e = (BaseNessieClientServerException)exception;
            errorCode = e.getErrorCode();
            message = exception.getMessage();
            return this.buildExceptionResponse(errorCode, message, exception);
        } else if (exception.getCause() instanceof BaseNessieClientServerException) {
            BaseNessieClientServerException e = (BaseNessieClientServerException)exception.getCause();
            errorCode = e.getErrorCode();
            message = exception.getCause().getMessage();
            return this.buildExceptionResponse(errorCode, message, exception);
        } else if (exception instanceof JsonParseException || exception instanceof JsonMappingException || exception instanceof IllegalArgumentException) {
            errorCode = ErrorCode.BAD_REQUEST;
            message = exception.getMessage();
            return this.buildExceptionResponse(errorCode, message, exception);
        } else if (exception instanceof WebApplicationException) {
            if (!(exception.getCause() instanceof IllegalArgumentException) || ((WebApplicationException)exception).getResponse().getStatus() != 404) return ((WebApplicationException)exception).getResponse();
            errorCode = ErrorCode.BAD_REQUEST;
            message = exception.getCause().getMessage();
            return this.buildExceptionResponse(errorCode, message, exception);
        } else {
            LOGGER.warn("Unhandled exception returned as HTTP/500 to client", (Throwable)exception);
            errorCode = ErrorCode.UNKNOWN;
            message = Throwables.getCausalChain((Throwable)exception).stream().map(Throwable::toString).collect(Collectors.joining(", caused by "));
        }
        return this.buildExceptionResponse(errorCode, message, exception);
    }
}

