/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import com.fasterxml.jackson.annotation.JsonView;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Path;
import org.projectnessie.api.v1.http.HttpDiffApi;
import org.projectnessie.api.v1.params.DiffParams;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.DiffResponse;
import org.projectnessie.model.ImmutableDiffResponse;
import org.projectnessie.model.ser.Views;
import org.projectnessie.services.authz.AccessContext;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.DiffApiImpl;
import org.projectnessie.services.impl.RefUtil;
import org.projectnessie.services.rest.RestApiContext;
import org.projectnessie.services.spi.DiffService;
import org.projectnessie.services.spi.PagedResponseHandler;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;

@RequestScoped
@Path(value="api/v1/diffs")
public class RestDiffResource
implements HttpDiffApi {
    private final DiffService diffService;

    public RestDiffResource() {
        this(null, null, null, null);
    }

    @Inject
    public RestDiffResource(ServerConfig config, VersionStore store, Authorizer authorizer, AccessContext accessContext) {
        this.diffService = new DiffApiImpl(config, store, authorizer, accessContext, RestApiContext.NESSIE_V1);
    }

    private DiffService resource() {
        return this.diffService;
    }

    @JsonView(value={Views.V1.class})
    public DiffResponse getDiff(DiffParams params) throws NessieNotFoundException {
        final ImmutableDiffResponse.Builder builder = DiffResponse.builder();
        return (DiffResponse)this.resource().getDiff(params.getFromRef(), params.getFromHashOnRef(), params.getToRef(), params.getToHashOnRef(), null, (PagedResponseHandler)new PagedResponseHandler<DiffResponse, DiffResponse.DiffEntry>(){

            public DiffResponse build() {
                return builder.build();
            }

            public boolean addEntry(DiffResponse.DiffEntry entry) {
                builder.addDiffs(entry);
                return true;
            }

            public void hasMore(String pagingToken) {
                builder.isHasMore(true).token(pagingToken);
            }
        }, h -> builder.effectiveFromReference(RefUtil.toReference((WithHash)h)), h -> builder.effectiveToReference(RefUtil.toReference((WithHash)h)), null, null, null, null, null);
    }
}

