/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import com.fasterxml.jackson.annotation.JsonView;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.projectnessie.api.v1.http.HttpDiffApi;
import org.projectnessie.api.v1.params.DiffParams;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.DiffResponse;
import org.projectnessie.model.ImmutableDiffResponse;
import org.projectnessie.model.ser.Views;
import org.projectnessie.services.impl.RefUtil;
import org.projectnessie.services.spi.DiffService;
import org.projectnessie.services.spi.PagedResponseHandler;
import org.projectnessie.versioned.WithHash;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@RequestScoped
@jakarta.enterprise.context.RequestScoped
public class RestDiffResource
implements HttpDiffApi {
    private final DiffService diffService;

    public RestDiffResource() {
        this(null);
    }

    @Inject
    @jakarta.inject.Inject
    public RestDiffResource(DiffService diffService) {
        this.diffService = diffService;
    }

    private DiffService resource() {
        return this.diffService;
    }

    @JsonView(value={Views.V1.class})
    public DiffResponse getDiff(DiffParams params) throws NessieNotFoundException {
        final ImmutableDiffResponse.Builder builder = DiffResponse.builder();
        return (DiffResponse)this.resource().getDiff(params.getFromRef(), params.getFromHashOnRef(), params.getToRef(), params.getToHashOnRef(), null, (PagedResponseHandler)new PagedResponseHandler<DiffResponse, DiffResponse.DiffEntry>(){

            public DiffResponse build() {
                return builder.build();
            }

            public boolean addEntry(DiffResponse.DiffEntry entry) {
                builder.addDiffs(entry);
                return true;
            }

            public void hasMore(String pagingToken) {
                builder.isHasMore(true).token(pagingToken);
            }
        }, h -> builder.effectiveFromReference(RefUtil.toReference((WithHash)h)), h -> builder.effectiveToReference(RefUtil.toReference((WithHash)h)));
    }
}

