/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.restjakarta;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.Throwables;
import jakarta.inject.Inject;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.util.stream.Collectors;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.services.authz.AccessCheckException;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.restjakarta.BaseExceptionMapper;
import org.projectnessie.versioned.BackendLimitExceededException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Provider
public class NessieExceptionMapper
extends BaseExceptionMapper<Exception> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NessieExceptionMapper.class);

    public NessieExceptionMapper() {
        this(null);
    }

    @Inject
    public NessieExceptionMapper(ServerConfig config) {
        super(config);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Response toResponse(Exception exception) {
        String message;
        ErrorCode errorCode;
        if (exception instanceof BaseNessieClientServerException) {
            BaseNessieClientServerException e = (BaseNessieClientServerException)exception;
            errorCode = e.getErrorCode();
            message = exception.getMessage();
            return this.buildExceptionResponse(errorCode, message, exception);
        } else if (exception.getCause() instanceof BaseNessieClientServerException) {
            BaseNessieClientServerException e = (BaseNessieClientServerException)exception.getCause();
            errorCode = e.getErrorCode();
            message = exception.getCause().getMessage();
            return this.buildExceptionResponse(errorCode, message, exception);
        } else if (exception instanceof JsonParseException || exception instanceof JsonMappingException || exception instanceof IllegalArgumentException) {
            errorCode = ErrorCode.BAD_REQUEST;
            message = exception.getMessage();
            return this.buildExceptionResponse(errorCode, message, exception);
        } else if (exception instanceof BackendLimitExceededException) {
            LOGGER.warn("Backend throttled/refused the request: {}", (Object)exception.toString());
            errorCode = ErrorCode.TOO_MANY_REQUESTS;
            message = "Backend store refused to process the request: " + exception;
            return this.buildExceptionResponse(errorCode, message, exception);
        } else if (exception instanceof AccessCheckException) {
            errorCode = ErrorCode.FORBIDDEN;
            message = exception.getMessage();
            return this.buildExceptionResponse(errorCode, message, exception);
        } else if (exception instanceof NotSupportedException) {
            errorCode = ErrorCode.UNSUPPORTED_MEDIA_TYPE;
            message = exception.getMessage();
            return this.buildExceptionResponse(errorCode, message, exception);
        } else if (exception instanceof WebApplicationException) {
            if (!(exception.getCause() instanceof IllegalArgumentException) || ((WebApplicationException)exception).getResponse().getStatus() != 404) return ((WebApplicationException)exception).getResponse();
            errorCode = ErrorCode.BAD_REQUEST;
            message = exception.getCause().getMessage();
            return this.buildExceptionResponse(errorCode, message, exception);
        } else {
            LOGGER.warn("Unhandled exception returned as HTTP/500 to client", (Throwable)exception);
            errorCode = ErrorCode.UNKNOWN;
            message = Throwables.getCausalChain((Throwable)exception).stream().map(Throwable::toString).collect(Collectors.joining(", caused by "));
        }
        return this.buildExceptionResponse(errorCode, message, exception);
    }
}

