/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.restjakarta;

import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import java.util.function.Consumer;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.error.NessieError;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.rest.RestCommon;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class BaseExceptionMapper<T extends Throwable>
implements ExceptionMapper<T> {
    private final ServerConfig serverConfig;
    private HttpHeaders headers;

    protected BaseExceptionMapper(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    protected Response buildBadRequestResponse(Exception e) {
        return this.buildExceptionResponse(ErrorCode.BAD_REQUEST, e.getMessage(), e);
    }

    protected Response buildExceptionResponse(ErrorCode errorCode, String message, Exception e) {
        return this.buildExceptionResponse(errorCode, message, e, this.serverConfig.sendStacktraceToClient(), h -> {});
    }

    protected Response buildExceptionResponse(ErrorCode errorCode, String message, Exception e, boolean includeExceptionStackTrace, Consumer<Response.ResponseBuilder> responseHandler) {
        Response.Status status = Response.Status.fromStatusCode((int)errorCode.httpStatus());
        if (status == null) {
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        NessieError error = RestCommon.buildNessieError(message, status.getStatusCode(), status.getReasonPhrase(), errorCode, e, includeExceptionStackTrace, arg_0 -> ((HttpHeaders)this.headers).getHeaderString(arg_0));
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)status).entity((Object)error).type(MediaType.APPLICATION_JSON_TYPE);
        responseHandler.accept(responseBuilder);
        return responseBuilder.build();
    }
}

