/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.restjakarta;

import jakarta.validation.ValidationException;
import jakarta.ws.rs.core.Response;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.restjakarta.BaseExceptionMapper;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ValidationExceptionMapper
extends BaseExceptionMapper<ValidationException> {
    public ValidationExceptionMapper() {
        this(null);
    }

    public ValidationExceptionMapper(ServerConfig config) {
        super(config);
    }

    public Response toResponse(ValidationException exception) {
        return this.buildExceptionResponse(ErrorCode.UNKNOWN, this.unwrapException((Throwable)exception), (Exception)exception);
    }

    protected String unwrapException(Throwable t) {
        StringBuilder sb = new StringBuilder();
        this.doUnwrapException(sb, t);
        return sb.toString();
    }

    private void doUnwrapException(StringBuilder sb, Throwable t) {
        if (t == null) {
            return;
        }
        sb.append(t);
        if (t.getCause() != null && t != t.getCause()) {
            sb.append('[');
            this.doUnwrapException(sb, t.getCause());
            sb.append(']');
        }
    }
}

