/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.restjavax;

import java.util.function.Consumer;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.error.NessieError;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.rest.RestCommon;

public abstract class BaseExceptionMapper<T extends Throwable>
implements ExceptionMapper<T> {
    private final ServerConfig serverConfig;
    @Context
    private HttpHeaders headers;

    protected BaseExceptionMapper(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    protected Response buildBadRequestResponse(Exception e) {
        return this.buildExceptionResponse(ErrorCode.BAD_REQUEST, e.getMessage(), e);
    }

    protected Response buildExceptionResponse(ErrorCode errorCode, String message, Exception e) {
        return this.buildExceptionResponse(errorCode, message, e, this.serverConfig.sendStacktraceToClient(), h -> {});
    }

    protected Response buildExceptionResponse(ErrorCode errorCode, String message, Exception e, boolean includeExceptionStackTrace, Consumer<Response.ResponseBuilder> responseHandler) {
        Response.Status status = Response.Status.fromStatusCode((int)errorCode.httpStatus());
        if (status == null) {
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        NessieError error = RestCommon.buildNessieError(message, status.getStatusCode(), status.getReasonPhrase(), errorCode, e, includeExceptionStackTrace, arg_0 -> ((HttpHeaders)this.headers).getHeaderString(arg_0));
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)status).entity((Object)error).type(MediaType.APPLICATION_JSON_TYPE);
        responseHandler.accept(responseBuilder);
        return responseBuilder.build();
    }
}

