/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import com.fasterxml.jackson.annotation.JsonView;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Path;
import java.security.Principal;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.projectnessie.api.v2.http.HttpConfigApi;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.model.ImmutableRepositoryConfigResponse;
import org.projectnessie.model.ImmutableUpdateRepositoryConfigResponse;
import org.projectnessie.model.NessieConfiguration;
import org.projectnessie.model.RepositoryConfigResponse;
import org.projectnessie.model.UpdateRepositoryConfigRequest;
import org.projectnessie.model.UpdateRepositoryConfigResponse;
import org.projectnessie.model.ser.Views;
import org.projectnessie.model.types.RepositoryConfigTypes;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.ConfigApiImpl;
import org.projectnessie.versioned.VersionStore;

@RequestScoped
@Path(value="api/v2/config")
public class RestV2ConfigResource
implements HttpConfigApi {
    private final ConfigApiImpl config;

    public RestV2ConfigResource() {
        this(null, null, null, null);
    }

    @Inject
    public RestV2ConfigResource(ServerConfig config, VersionStore store, Authorizer authorizer, Supplier<Principal> principal) {
        this.config = new ConfigApiImpl(config, store, authorizer, principal, 2);
    }

    @JsonView(value={Views.V2.class})
    public NessieConfiguration getConfig() {
        return this.config.getConfig();
    }

    public RepositoryConfigResponse getRepositoryConfig(List<String> repositoryConfigTypes) {
        Set types = repositoryConfigTypes.stream().map(RepositoryConfigTypes::forName).collect(Collectors.toSet());
        return ImmutableRepositoryConfigResponse.builder().addAllConfigs((Iterable)this.config.getRepositoryConfig(types)).build();
    }

    public UpdateRepositoryConfigResponse updateRepositoryConfig(UpdateRepositoryConfigRequest repositoryConfigUpdate) throws NessieConflictException {
        return ImmutableUpdateRepositoryConfigResponse.builder().previous(this.config.updateRepositoryConfig(repositoryConfigUpdate.getConfig())).build();
    }
}

