/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.services.rest.exceptions.BaseExceptionMapper;
import org.projectnessie.versioned.BackendLimitExceededException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@ApplicationScoped
public class BackendLimitExceededExceptionMapper
extends BaseExceptionMapper<BackendLimitExceededException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackendLimitExceededExceptionMapper.class);

    public Response toResponse(BackendLimitExceededException exception) {
        LOGGER.warn("Backend throttled/refused the request: {}", (Object)exception.toString());
        ErrorCode errorCode = ErrorCode.TOO_MANY_REQUESTS;
        String message = "Backend store refused to process the request: " + exception;
        return this.buildExceptionResponse(errorCode, message, (Exception)exception);
    }
}

