/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import com.fasterxml.jackson.annotation.JsonView;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Path;
import org.projectnessie.api.v1.http.HttpNamespaceApi;
import org.projectnessie.api.v1.params.MultipleNamespacesParams;
import org.projectnessie.api.v1.params.NamespaceParams;
import org.projectnessie.api.v1.params.NamespaceUpdate;
import org.projectnessie.error.NessieNamespaceAlreadyExistsException;
import org.projectnessie.error.NessieNamespaceNotEmptyException;
import org.projectnessie.error.NessieNamespaceNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.GetNamespacesResponse;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.ser.Views;
import org.projectnessie.services.spi.NamespaceService;

@RequestScoped
@Path(value="api/v1/namespaces")
public class RestNamespaceResource
implements HttpNamespaceApi {
    private final NamespaceService namespaceService;

    public RestNamespaceResource() {
        this(null);
    }

    @Inject
    public RestNamespaceResource(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    private NamespaceService resource() {
        return this.namespaceService;
    }

    @JsonView(value={Views.V1.class})
    public Namespace createNamespace(NamespaceParams params, Namespace namespace) throws NessieNamespaceAlreadyExistsException, NessieReferenceNotFoundException {
        return this.resource().createNamespace(params.getRefName(), namespace);
    }

    @JsonView(value={Views.V1.class})
    public void deleteNamespace(@NotNull NamespaceParams params) throws NessieReferenceNotFoundException, NessieNamespaceNotEmptyException, NessieNamespaceNotFoundException {
        this.resource().deleteNamespace(params.getRefName(), params.getNamespace());
    }

    @JsonView(value={Views.V1.class})
    public Namespace getNamespace(@NotNull NamespaceParams params) throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException {
        return this.resource().getNamespace(params.getRefName(), params.getHashOnRef(), params.getNamespace());
    }

    @JsonView(value={Views.V1.class})
    public GetNamespacesResponse getNamespaces(@NotNull MultipleNamespacesParams params) throws NessieReferenceNotFoundException {
        return this.resource().getNamespaces(params.getRefName(), params.getHashOnRef(), params.getNamespace());
    }

    @JsonView(value={Views.V1.class})
    public void updateProperties(NamespaceParams params, NamespaceUpdate namespaceUpdate) throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException {
        this.resource().updateProperties(params.getRefName(), params.getNamespace(), namespaceUpdate.getPropertyUpdates(), namespaceUpdate.getPropertyRemovals());
    }
}

