/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import com.fasterxml.jackson.annotation.JsonView;
import com.google.common.base.Preconditions;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Path;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.projectnessie.api.v2.http.HttpTreeApi;
import org.projectnessie.api.v2.params.CommitLogParams;
import org.projectnessie.api.v2.params.DiffParams;
import org.projectnessie.api.v2.params.EntriesParams;
import org.projectnessie.api.v2.params.GetReferenceParams;
import org.projectnessie.api.v2.params.Merge;
import org.projectnessie.api.v2.params.ParsedReference;
import org.projectnessie.api.v2.params.ReferenceHistoryParams;
import org.projectnessie.api.v2.params.ReferenceResolver;
import org.projectnessie.api.v2.params.ReferencesParams;
import org.projectnessie.api.v2.params.Transplant;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.CommitResponse;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ContentResponse;
import org.projectnessie.model.DiffResponse;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.GetMultipleContentsRequest;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.model.ImmutableDiffResponse;
import org.projectnessie.model.ImmutableEntriesResponse;
import org.projectnessie.model.ImmutableGetMultipleContentsRequest;
import org.projectnessie.model.ImmutableLogResponse;
import org.projectnessie.model.ImmutableReferencesResponse;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.MergeResponse;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferenceHistoryResponse;
import org.projectnessie.model.ReferencesResponse;
import org.projectnessie.model.SingleReferenceResponse;
import org.projectnessie.model.ser.Views;
import org.projectnessie.services.impl.RefUtil;
import org.projectnessie.services.spi.ConfigService;
import org.projectnessie.services.spi.ContentService;
import org.projectnessie.services.spi.DiffService;
import org.projectnessie.services.spi.PagedCountingResponseHandler;
import org.projectnessie.services.spi.PagedResponseHandler;
import org.projectnessie.services.spi.TreeService;
import org.projectnessie.versioned.WithHash;

@RequestScoped
@Path(value="api/v2/trees")
public class RestV2TreeResource
implements HttpTreeApi {
    private final ConfigService configService;
    private final TreeService treeService;
    private final ContentService contentService;
    private final DiffService diffService;

    public RestV2TreeResource() {
        this(null, null, null, null);
    }

    @Inject
    public RestV2TreeResource(ConfigService configService, TreeService treeService, ContentService contentService, DiffService diffService) {
        this.configService = configService;
        this.treeService = treeService;
        this.contentService = contentService;
        this.diffService = diffService;
    }

    private ParsedReference parseRefPathString(String refPathString) {
        return this.parseRefPathString(refPathString, Reference.ReferenceType.BRANCH);
    }

    private ParsedReference parseRefPathString(String refPathString, Reference.ReferenceType referenceType) {
        return ReferenceResolver.resolveReferencePathElement((String)refPathString, (Reference.ReferenceType)referenceType, () -> this.configService.getConfig().getDefaultBranch());
    }

    private TreeService tree() {
        return this.treeService;
    }

    private DiffService diff() {
        return this.diffService;
    }

    private ContentService content() {
        return this.contentService;
    }

    @JsonView(value={Views.V2.class})
    public ReferencesResponse getAllReferences(ReferencesParams params) {
        Integer maxRecords = params.maxRecords();
        return (ReferencesResponse)this.tree().getAllReferences(params.fetchOption(), params.filter(), params.pageToken(), (PagedResponseHandler)new PagedCountingResponseHandler<ReferencesResponse, Reference>(maxRecords){
            final ImmutableReferencesResponse.Builder builder;
            {
                this.builder = ReferencesResponse.builder();
            }

            public ReferencesResponse build() {
                return this.builder.build();
            }

            protected boolean doAddEntry(Reference entry) {
                this.builder.addReferences(entry);
                return true;
            }

            public void hasMore(String pagingToken) {
                this.builder.isHasMore(true).token(pagingToken);
            }
        });
    }

    @JsonView(value={Views.V2.class})
    public SingleReferenceResponse createReference(String name, String type, Reference reference) throws NessieNotFoundException, NessieConflictException {
        Reference.ReferenceType referenceType = RestV2TreeResource.parseReferenceType(type);
        Preconditions.checkArgument((referenceType != null ? 1 : 0) != 0, (Object)"Mandatory reference type missing");
        String fromRefName = null;
        String fromHash = null;
        if (reference != null) {
            fromRefName = reference.getName();
            fromHash = reference.getHash();
        }
        Reference created = this.tree().createReference(name, referenceType, fromHash, fromRefName);
        return SingleReferenceResponse.builder().reference(created).build();
    }

    @JsonView(value={Views.V2.class})
    public SingleReferenceResponse getReferenceByName(GetReferenceParams params) throws NessieNotFoundException {
        ParsedReference reference = this.parseRefPathString(params.getRef());
        Preconditions.checkArgument((reference.hashWithRelativeSpec() == null ? 1 : 0) != 0, (Object)"Hashes are not allowed when fetching a reference by name");
        return SingleReferenceResponse.builder().reference(this.tree().getReferenceByName(reference.name(), params.fetchOption())).build();
    }

    @JsonView(value={Views.V2.class})
    public ReferenceHistoryResponse getReferenceHistory(ReferenceHistoryParams params) throws NessieNotFoundException {
        ParsedReference reference = this.parseRefPathString(params.getRef());
        Preconditions.checkArgument((reference.hashWithRelativeSpec() == null ? 1 : 0) != 0, (Object)"Hashes are not allowed when fetching a reference history");
        return this.tree().getReferenceHistory(reference.name(), params.headCommitsToScan());
    }

    @JsonView(value={Views.V2.class})
    public EntriesResponse getEntries(String ref, EntriesParams params) throws NessieNotFoundException {
        ParsedReference reference = this.parseRefPathString(ref);
        Integer maxRecords = params.maxRecords();
        final ImmutableEntriesResponse.Builder builder = EntriesResponse.builder();
        return (EntriesResponse)this.tree().getEntries(reference.name(), reference.hashWithRelativeSpec(), null, params.filter(), params.pageToken(), params.withContent(), (PagedResponseHandler)new PagedCountingResponseHandler<EntriesResponse, EntriesResponse.Entry>(maxRecords){

            public EntriesResponse build() {
                return builder.build();
            }

            protected boolean doAddEntry(EntriesResponse.Entry entry) {
                builder.addEntries(entry);
                return true;
            }

            public void hasMore(String pagingToken) {
                builder.isHasMore(true).token(pagingToken);
            }
        }, h -> builder.effectiveReference(RefUtil.toReference((WithHash)h)), params.minKey(), params.maxKey(), params.prefixKey(), params.getRequestedKeys());
    }

    @JsonView(value={Views.V2.class})
    public LogResponse getCommitLog(String ref, CommitLogParams params) throws NessieNotFoundException {
        ParsedReference reference = this.parseRefPathString(ref);
        Integer maxRecords = params.maxRecords();
        return (LogResponse)this.tree().getCommitLog(reference.name(), params.fetchOption(), params.startHash(), reference.hashWithRelativeSpec(), params.filter(), params.pageToken(), (PagedResponseHandler)new PagedCountingResponseHandler<LogResponse, LogResponse.LogEntry>(maxRecords, 250){
            final ImmutableLogResponse.Builder builder;
            {
                this.builder = ImmutableLogResponse.builder();
            }

            public LogResponse build() {
                return this.builder.build();
            }

            protected boolean doAddEntry(LogResponse.LogEntry entry) {
                this.builder.addLogEntries(entry);
                return true;
            }

            public void hasMore(String pagingToken) {
                this.builder.isHasMore(true).token(pagingToken);
            }
        });
    }

    @JsonView(value={Views.V2.class})
    public DiffResponse getDiff(DiffParams params) throws NessieNotFoundException {
        Integer maxRecords = params.maxRecords();
        ParsedReference from = this.parseRefPathString(params.getFromRef());
        ParsedReference to = this.parseRefPathString(params.getToRef());
        final ImmutableDiffResponse.Builder builder = DiffResponse.builder();
        return (DiffResponse)this.diff().getDiff(from.name(), from.hashWithRelativeSpec(), to.name(), to.hashWithRelativeSpec(), params.pageToken(), (PagedResponseHandler)new PagedCountingResponseHandler<DiffResponse, DiffResponse.DiffEntry>(maxRecords){

            public DiffResponse build() {
                return builder.build();
            }

            protected boolean doAddEntry(DiffResponse.DiffEntry entry) {
                builder.addDiffs(entry);
                return true;
            }

            public void hasMore(String pagingToken) {
                builder.isHasMore(true).token(pagingToken);
            }
        }, h -> builder.effectiveFromReference(RefUtil.toReference((WithHash)h)), h -> builder.effectiveToReference(RefUtil.toReference((WithHash)h)), params.minKey(), params.maxKey(), params.prefixKey(), params.getRequestedKeys(), params.getFilter());
    }

    @JsonView(value={Views.V2.class})
    public SingleReferenceResponse assignReference(String type, String ref, Reference assignTo) throws NessieNotFoundException, NessieConflictException {
        ParsedReference reference = this.parseRefPathString(ref, RestV2TreeResource.parseReferenceType(type));
        Reference updated = this.tree().assignReference(reference.type(), reference.name(), reference.hashWithRelativeSpec(), assignTo);
        return SingleReferenceResponse.builder().reference(updated).build();
    }

    @JsonView(value={Views.V2.class})
    public SingleReferenceResponse deleteReference(String type, String ref) throws NessieConflictException, NessieNotFoundException {
        ParsedReference reference = this.parseRefPathString(ref, RestV2TreeResource.parseReferenceType(type));
        Reference deleted = this.tree().deleteReference(reference.type(), reference.name(), reference.hashWithRelativeSpec());
        return SingleReferenceResponse.builder().reference(deleted).build();
    }

    private static Reference.ReferenceType parseReferenceType(String type) {
        if (type == null) {
            return null;
        }
        return Reference.ReferenceType.valueOf((String)type.toUpperCase(Locale.ROOT));
    }

    @JsonView(value={Views.V2.class})
    public ContentResponse getContent(ContentKey key, String ref, boolean withDocumentation, boolean forWrite) throws NessieNotFoundException {
        ParsedReference reference = this.parseRefPathString(ref);
        return this.content().getContent(key, reference.name(), reference.hashWithRelativeSpec(), withDocumentation, forWrite);
    }

    @JsonView(value={Views.V2.class})
    public GetMultipleContentsResponse getSeveralContents(String ref, List<String> keys, boolean withDocumentation, boolean forWrite) throws NessieNotFoundException {
        ImmutableGetMultipleContentsRequest.Builder request = GetMultipleContentsRequest.builder();
        keys.forEach(k -> request.addRequestedKeys(ContentKey.fromPathString((String)k)));
        return this.getMultipleContents(ref, (GetMultipleContentsRequest)request.build(), withDocumentation, forWrite);
    }

    @JsonView(value={Views.V2.class})
    public GetMultipleContentsResponse getMultipleContents(String ref, GetMultipleContentsRequest request, boolean withDocumentation, boolean forWrite) throws NessieNotFoundException {
        ParsedReference reference = this.parseRefPathString(ref);
        return this.content().getMultipleContents(reference.name(), reference.hashWithRelativeSpec(), request.getRequestedKeys(), withDocumentation, forWrite);
    }

    @JsonView(value={Views.V2.class})
    public MergeResponse transplantCommitsIntoBranch(String branch, Transplant transplant) throws NessieNotFoundException, NessieConflictException {
        ParsedReference ref = this.parseRefPathString(branch);
        String msg = transplant.getMessage();
        CommitMeta meta = CommitMeta.fromMessage((String)(msg == null ? "" : msg));
        return this.tree().transplantCommitsIntoBranch(ref.name(), ref.hashWithRelativeSpec(), meta, transplant.getHashesToTransplant(), transplant.getFromRefName(), (Collection)transplant.getKeyMergeModes(), transplant.getDefaultKeyMergeMode(), transplant.isDryRun(), transplant.isFetchAdditionalInfo(), transplant.isReturnConflictAsResult());
    }

    @JsonView(value={Views.V2.class})
    public MergeResponse mergeRefIntoBranch(String branch, Merge merge) throws NessieNotFoundException, NessieConflictException {
        ParsedReference ref = this.parseRefPathString(branch);
        String msg = merge.getMessage();
        ImmutableCommitMeta.Builder meta = CommitMeta.builder();
        CommitMeta commitMeta = merge.getCommitMeta();
        if (commitMeta != null) {
            meta.from(commitMeta);
            if (commitMeta.getMessage().isEmpty() && msg != null) {
                meta.message(msg);
            }
        } else {
            meta.message(msg == null ? "" : msg);
        }
        return this.tree().mergeRefIntoBranch(ref.name(), ref.hashWithRelativeSpec(), merge.getFromRefName(), merge.getFromHash(), (CommitMeta)meta.build(), (Collection)merge.getKeyMergeModes(), merge.getDefaultKeyMergeMode(), merge.isDryRun(), merge.isFetchAdditionalInfo(), merge.isReturnConflictAsResult());
    }

    @JsonView(value={Views.V2.class})
    public CommitResponse commitMultipleOperations(String branch, Operations operations) throws NessieNotFoundException, NessieConflictException {
        ParsedReference ref = this.parseRefPathString(branch);
        return this.tree().commitMultipleOperations(ref.name(), ref.hashWithRelativeSpec(), operations);
    }
}

