/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import com.fasterxml.jackson.annotation.JsonView;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Path;
import org.projectnessie.api.v1.http.HttpConfigApi;
import org.projectnessie.model.NessieConfiguration;
import org.projectnessie.model.ser.Views;
import org.projectnessie.services.authz.AccessContext;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.ConfigApiImpl;
import org.projectnessie.services.rest.RestApiContext;
import org.projectnessie.services.spi.ConfigService;
import org.projectnessie.versioned.VersionStore;

@RequestScoped
@Path(value="api/v1/config")
public class RestConfigResource
implements HttpConfigApi {
    private final ConfigService configService;

    public RestConfigResource() {
        this(null, null, null, null);
    }

    @Inject
    public RestConfigResource(ServerConfig config, VersionStore store, Authorizer authorizer, AccessContext accessContext) {
        this.configService = new ConfigApiImpl(config, store, authorizer, accessContext, RestApiContext.NESSIE_V1);
    }

    @JsonView(value={Views.V1.class})
    public NessieConfiguration getConfig() {
        return this.configService.getConfig();
    }
}

