/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import com.fasterxml.jackson.annotation.JsonView;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Path;
import org.projectnessie.api.v1.http.HttpContentApi;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.GetMultipleContentsRequest;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.model.ser.Views;
import org.projectnessie.services.authz.AccessContext;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.ContentApiImpl;
import org.projectnessie.services.rest.RestApiContext;
import org.projectnessie.services.spi.ContentService;
import org.projectnessie.versioned.RequestMeta;
import org.projectnessie.versioned.VersionStore;

@RequestScoped
@Path(value="api/v1/contents")
public class RestContentResource
implements HttpContentApi {
    private final ContentService contentService;

    public RestContentResource() {
        this(null, null, null, null);
    }

    @Inject
    public RestContentResource(ServerConfig config, VersionStore store, Authorizer authorizer, AccessContext accessContext) {
        this.contentService = new ContentApiImpl(config, store, authorizer, accessContext, RestApiContext.NESSIE_V1);
    }

    private ContentService resource() {
        return this.contentService;
    }

    @JsonView(value={Views.V1.class})
    public Content getContent(ContentKey key, String ref, String hashOnRef) throws NessieNotFoundException {
        return this.resource().getContent(key, ref, hashOnRef, false, RequestMeta.API_READ).getContent();
    }

    @JsonView(value={Views.V1.class})
    public GetMultipleContentsResponse getMultipleContents(String ref, String hashOnRef, GetMultipleContentsRequest request) throws NessieNotFoundException {
        return this.resource().getMultipleContents(ref, hashOnRef, request.getRequestedKeys(), false, RequestMeta.API_READ);
    }
}

