/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import com.fasterxml.jackson.annotation.JsonView;
import com.google.common.base.Preconditions;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Path;
import java.util.Collection;
import org.projectnessie.api.v1.http.HttpTreeApi;
import org.projectnessie.api.v1.params.BaseMergeTransplant;
import org.projectnessie.api.v1.params.CommitLogParams;
import org.projectnessie.api.v1.params.EntriesParams;
import org.projectnessie.api.v1.params.GetReferenceParams;
import org.projectnessie.api.v1.params.Merge;
import org.projectnessie.api.v1.params.ReferencesParams;
import org.projectnessie.api.v1.params.Transplant;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.ImmutableEntriesResponse;
import org.projectnessie.model.ImmutableLogResponse;
import org.projectnessie.model.ImmutableReferencesResponse;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.MergeResponse;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferencesResponse;
import org.projectnessie.model.ser.Views;
import org.projectnessie.services.authz.AccessContext;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.RefUtil;
import org.projectnessie.services.impl.TreeApiImpl;
import org.projectnessie.services.rest.RestApiContext;
import org.projectnessie.services.spi.PagedCountingResponseHandler;
import org.projectnessie.services.spi.PagedResponseHandler;
import org.projectnessie.services.spi.TreeService;
import org.projectnessie.versioned.RequestMeta;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;

@RequestScoped
@Path(value="api/v1/trees")
public class RestTreeResource
implements HttpTreeApi {
    private final TreeService treeService;

    public RestTreeResource() {
        this(null, null, null, null);
    }

    @Inject
    public RestTreeResource(ServerConfig config, VersionStore store, Authorizer authorizer, AccessContext accessContext) {
        this.treeService = new TreeApiImpl(config, store, authorizer, accessContext, RestApiContext.NESSIE_V1);
    }

    private TreeService resource() {
        return this.treeService;
    }

    @JsonView(value={Views.V1.class})
    public ReferencesResponse getAllReferences(ReferencesParams params) {
        Integer maxRecords = params.maxRecords();
        return (ReferencesResponse)this.resource().getAllReferences(params.fetchOption(), params.filter(), params.pageToken(), (PagedResponseHandler)new PagedCountingResponseHandler<ReferencesResponse, Reference>(maxRecords){
            final ImmutableReferencesResponse.Builder builder;
            {
                this.builder = ReferencesResponse.builder();
            }

            public ReferencesResponse build() {
                return this.builder.build();
            }

            protected boolean doAddEntry(Reference entry) {
                this.builder.addReferences(entry);
                return true;
            }

            public void hasMore(String pagingToken) {
                this.builder.isHasMore(true).token(pagingToken);
            }
        });
    }

    @JsonView(value={Views.V1.class})
    public Branch getDefaultBranch() throws NessieNotFoundException {
        return this.resource().getDefaultBranch();
    }

    @JsonView(value={Views.V1.class})
    public Reference createReference(String sourceRefName, Reference reference) throws NessieNotFoundException, NessieConflictException {
        return this.resource().createReference(reference.getName(), reference.getType(), reference.getHash(), sourceRefName);
    }

    @JsonView(value={Views.V1.class})
    public Reference getReferenceByName(GetReferenceParams params) throws NessieNotFoundException {
        return this.resource().getReferenceByName(params.getRefName(), params.fetchOption());
    }

    @JsonView(value={Views.V1.class})
    public EntriesResponse getEntries(String refName, EntriesParams params) throws NessieNotFoundException {
        Integer maxRecords = params.maxRecords();
        final ImmutableEntriesResponse.Builder builder = EntriesResponse.builder();
        return (EntriesResponse)this.resource().getEntries(refName, params.hashOnRef(), params.namespaceDepth(), params.filter(), params.pageToken(), false, (PagedResponseHandler)new PagedCountingResponseHandler<EntriesResponse, EntriesResponse.Entry>(maxRecords){

            public EntriesResponse build() {
                return builder.build();
            }

            protected boolean doAddEntry(EntriesResponse.Entry entry) {
                builder.addEntries(entry);
                return true;
            }

            public void hasMore(String pagingToken) {
                builder.isHasMore(true).token(pagingToken);
            }
        }, h -> builder.effectiveReference(RefUtil.toReference((WithHash)h)), null, null, null, null);
    }

    @JsonView(value={Views.V1.class})
    public LogResponse getCommitLog(String ref, CommitLogParams params) throws NessieNotFoundException {
        Integer maxRecords = params.maxRecords();
        return (LogResponse)this.resource().getCommitLog(ref, params.fetchOption(), params.startHash(), params.endHash(), params.filter(), params.pageToken(), (PagedResponseHandler)new PagedCountingResponseHandler<LogResponse, LogResponse.LogEntry>(maxRecords, 250){
            final ImmutableLogResponse.Builder builder;
            {
                this.builder = ImmutableLogResponse.builder();
            }

            public LogResponse build() {
                return this.builder.build();
            }

            protected boolean doAddEntry(LogResponse.LogEntry entry) {
                this.builder.addLogEntries(entry);
                return true;
            }

            public void hasMore(String pagingToken) {
                this.builder.isHasMore(true).token(pagingToken);
            }
        });
    }

    @JsonView(value={Views.V1.class})
    public void assignReference(Reference.ReferenceType referenceType, String referenceName, String expectedHash, Reference assignTo) throws NessieNotFoundException, NessieConflictException {
        this.resource().assignReference(referenceType, referenceName, expectedHash, assignTo);
    }

    @JsonView(value={Views.V1.class})
    public void deleteReference(Reference.ReferenceType referenceType, String referenceName, String expectedHash) throws NessieConflictException, NessieNotFoundException {
        this.resource().deleteReference(referenceType, referenceName, expectedHash);
    }

    @JsonView(value={Views.V1.class})
    public MergeResponse transplantCommitsIntoBranch(String branchName, String expectedHash, String message, Transplant transplant) throws NessieNotFoundException, NessieConflictException {
        this.validateKeepIndividual((BaseMergeTransplant)transplant, true, "Transplant", "unsquashed");
        return this.resource().transplantCommitsIntoBranch(branchName, expectedHash, message != null ? CommitMeta.fromMessage((String)message) : null, transplant.getHashesToTransplant(), transplant.getFromRefName(), (Collection)transplant.getKeyMergeModes(), transplant.getDefaultKeyMergeMode(), transplant.isDryRun(), transplant.isFetchAdditionalInfo(), transplant.isReturnConflictAsResult());
    }

    @JsonView(value={Views.V1.class})
    public MergeResponse mergeRefIntoBranch(String branchName, String expectedHash, Merge merge) throws NessieNotFoundException, NessieConflictException {
        this.validateKeepIndividual((BaseMergeTransplant)merge, false, "Merge", "squashed");
        return this.resource().mergeRefIntoBranch(branchName, expectedHash, merge.getFromRefName(), merge.getFromHash(), null, (Collection)merge.getKeyMergeModes(), merge.getDefaultKeyMergeMode(), merge.isDryRun(), merge.isFetchAdditionalInfo(), merge.isReturnConflictAsResult());
    }

    private void validateKeepIndividual(BaseMergeTransplant base, boolean goodValue, String opsName, String supported) {
        Boolean keep = base.keepIndividualCommits();
        Preconditions.checkArgument((keep == null || keep == goodValue ? 1 : 0) != 0, (String)"The parameter 'keepIndividualCommits' is deprecated. %s operations only support %s now.", (Object)opsName, (Object)supported);
    }

    @JsonView(value={Views.V1.class})
    public Branch commitMultipleOperations(String branchName, String expectedHash, Operations operations) throws NessieNotFoundException, NessieConflictException {
        return this.resource().commitMultipleOperations(branchName, expectedHash, operations, RequestMeta.API_WRITE).getTargetBranch();
    }
}

