/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.store;

import org.projectnessie.model.Content;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.server.store.BaseSerializer;
import org.projectnessie.server.store.proto.ObjectTypes;

public final class IcebergTableSerializer
extends BaseSerializer<IcebergTable> {
    public Content.Type contentType() {
        return Content.Type.ICEBERG_TABLE;
    }

    public int payload() {
        return 1;
    }

    @Override
    protected void toStoreOnRefState(IcebergTable table, ObjectTypes.Content.Builder builder) {
        ObjectTypes.IcebergRefState.Builder stateBuilder = ObjectTypes.IcebergRefState.newBuilder().setSnapshotId(table.getSnapshotId()).setSchemaId(table.getSchemaId()).setSpecId(table.getSpecId()).setSortOrderId(table.getSortOrderId()).setMetadataLocation(table.getMetadataLocation());
        builder.setIcebergRefState(stateBuilder);
    }

    @Override
    protected IcebergTable valueFromStore(ObjectTypes.Content content) {
        return IcebergTableSerializer.valueFromStoreIcebergTable(content);
    }
}

