/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.store;

import org.projectnessie.model.Content;
import org.projectnessie.server.store.BaseSerializer;
import org.projectnessie.server.store.proto.ObjectTypes;

public final class UnknownSerializer
extends BaseSerializer<Content> {
    public Content.Type contentType() {
        return Content.Type.UNKNOWN;
    }

    public int payload() {
        return 0;
    }

    @Override
    protected void toStoreOnRefState(Content table, ObjectTypes.Content.Builder builder) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Content valueFromStore(ObjectTypes.Content content) {
        switch (content.getObjectTypeCase()) {
            case DELTA_LAKE_TABLE: {
                return UnknownSerializer.valueFromStoreDeltaLakeTable(content);
            }
            case ICEBERG_REF_STATE: {
                return UnknownSerializer.valueFromStoreIcebergTable(content);
            }
            case ICEBERG_VIEW_STATE: {
                return UnknownSerializer.valueFromStoreIcebergView(content);
            }
            case NAMESPACE: {
                return UnknownSerializer.valueFromStoreNamespace(content);
            }
            case UDF: {
                return UnknownSerializer.valueFromStoreUDF(content);
            }
        }
        throw new IllegalArgumentException("Unknown type " + String.valueOf(content.getObjectTypeCase()));
    }
}

