/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.store;

import org.projectnessie.model.Content;
import org.projectnessie.model.DeltaLakeTable;
import org.projectnessie.server.store.BaseSerializer;
import org.projectnessie.server.store.proto.ObjectTypes;

public final class DeltaLakeTableSerializer
extends BaseSerializer<DeltaLakeTable> {
    public Content.Type contentType() {
        return Content.Type.DELTA_LAKE_TABLE;
    }

    public int payload() {
        return 2;
    }

    @Override
    protected void toStoreOnRefState(DeltaLakeTable content, ObjectTypes.Content.Builder builder) {
        ObjectTypes.DeltaLakeTable.Builder table = ObjectTypes.DeltaLakeTable.newBuilder().addAllMetadataLocationHistory((Iterable)content.getMetadataLocationHistory()).addAllCheckpointLocationHistory((Iterable)content.getCheckpointLocationHistory());
        String lastCheckpoint = content.getLastCheckpoint();
        if (lastCheckpoint != null) {
            table.setLastCheckpoint(lastCheckpoint);
        }
        builder.setDeltaLakeTable(table);
    }

    @Override
    protected DeltaLakeTable valueFromStore(ObjectTypes.Content content) {
        return DeltaLakeTableSerializer.valueFromStoreDeltaLakeTable(content);
    }
}

